c
c     Reading Basis TAPE21 Sections
c
c     ******************************************************************
c
      subroutine rwbasis(iu,jout)
c
      include 'tape21.fh'
      integer iu,jout
      integer nbos,naos,ntyp
c
c     String defining ADF KF Section%SubSection
      character*(lchars) key
c
c ----------------------------------------------------------------------
c     Read Dimension Informations
c ----------------------------------------------------------------------
c
      key = 'Geometry%ntyp'
      call kfrdi(iu,key,ntyp)
      key = 'Basis%naos'
      call kfrdi(iu,key,naos)
      key = 'Basis%nbos'
      call kfrdi(iu,key,nbos)
c
c ----------------------------------------------------------------------
c     Call basis Subroutine
c ----------------------------------------------------------------------
c
      call compbasis(iu,jout,ntyp,naos,nbos)
c
c
      end
c
c
c
c
c
      subroutine compbasis(iu,jout,ntyp,naos,nbos)
c
c
      include 'tape21.fh'
      include 'general.fh'
      include 'comcoo.fh'
c
c      include 'basis.fh'
c
      integer ntyp,nqptr(ntyp1),naos
      integer natyp(ntypm)
      integer ifunc(naos,4)
      integer numat(naos)
      character atomtype*(lchars)
      dimension atomtype(nrepmx)
      double precision alpha(naos),bnorm(naos)
      double precision elec(natmx)
c
c
      integer iu,jout
      integer nbos,ntot
      integer nbptr(ntyp+1)
      Integer nftyp(ntyp)
      integer iwk1(nbos), iwk2(nbos), iwk3(nbos), iwk4(nbos)
      integer nfun, nfn, nft, nfts,nfst
      integer ilo, ihi, ibf, iat
      double precision rwk1(nbos), rwk2(nbos)
      double precision zet(ntyp)

c     String defining ADF KF Section%SubSection
      character*(lchars) key
c
      integer i,j,l,nat,ityp
      character cdummy*(lchars)
c
c     common for atom nuclear charge
c
      common /nucharge/ elec
c
      double precision angs
      Data angs /0.529177249D00/
c
  200 format(3(1x,f10.3),5x,f8.2)
c
c

c
c ----------------------------------------------------------------------
c     Section ADF Geomerty
c ----------------------------------------------------------------------
c
      key = 'Geometry%atomtype'
      call kfrdns(iu,key,atomtype,ntyp,1)
      key = 'Geometry%qtch'
      call kfrdnr(iu,key,zet,ntyp,1)
      key = 'Geometry%nqptr'
      call kfrdni(iu,key,nqptr,ntyp+1,1)
c
c ----------------------------------------------------------------------
c     Section ADF Basis
c ----------------------------------------------------------------------
c
      key = 'Basis%nbptr'
      call kfrdni(iu,key,nbptr,ntyp+1,1)
c
c  check dimensioning of the program
c
      if (naos.gt.naomx) then
         write(*,*) ' The allowed primitive functions ',naomx,
     1        ' are too few. Required: ',naos
         stop
      end if
c
      ntot = 0
      do i=1,ntyp
         natyp(i)=nqptr(i+1)-nqptr(i)
         nftyp(i)=nbptr(i+1)-nbptr(i)
         ntot=ntot+natyp(i)*nftyp(i)
      end do
c
      if(ntot.ne.naos) then
         write(*,*)' total no. of inequivalent basis functions ',
     +        ntot,' ne to naos. check data !!!'
         write(*,*)' naos=',naos
         stop
      end if
c
c ----------------------------------------------------------------------
c     Section ADF Basis Slater Type Orbitals  coefficients
c ----------------------------------------------------------------------
c
      key = 'Basis%kx'
      call kfrdni(iu,key,iwk1,nbos,1)
      key = 'Basis%ky'
      call kfrdni(iu,key,iwk2,nbos,1)
      key = 'Basis%kz'
      call kfrdni(iu,key,iwk3,nbos,1)
      key = 'Basis%kr'
      call kfrdni(iu,key,iwk4,nbos,1)
      key = 'Basis%alf'
      call kfrdnr(iu,key,rwk1,nbos,1)
      key = 'Basis%bnorm'
      call kfrdnr(iu,key,rwk2,nbos,1)
c
c     building the characteristic Slater type orbitals
c
      nfun=0
      nfn=0
      nft=0
      do i=1,ntyp
         ilo=nbptr(i)
         ihi=nbptr(i+1)-1
         do iat=1,natyp(i)
            if(iat.eq.1) then
               nfst=nfn
               nfts=nft
            endif
            if(iat.gt.1) then
               nfn=nfst
               nft=nfts
            endif
            do ibf=ilo,ihi
               nfun=nfun+1
               nfn=nfn+1
               nft=nft+1
               if(nfun.gt.naomx) then
                 write(*,*)' too many functions:',nfun,' increase naomx'
                 stop
               endif
               ifunc(nfun,1)=iwk1(nfn)
               ifunc(nfun,2)=iwk2(nfn)
               ifunc(nfun,3)=iwk3(nfn)
               ifunc(nfun,4)=iwk4(nfn)
               alpha(nfun)=rwk1(nft)
               bnorm(nfun)=rwk2(nft)
            end do
         end do
      enddo
c
c     outputting atomic coordinates and basis functions
c
      nfun=0
      nat=0
      do i=1,ntyp
         do iat=1,natyp(i)
            nat=nat+1
            elec(nat)=zet(i)
            write(namat(nat),'(a5)') atomtype(i)
            write(cdummy,200) (coo(nat,nft)*angs,nft=1,3),elec(nat)
            call cifwrite(cdummy)
            do nfn=1,nftyp(i)
               nfun=nfun+1
               numat(nfun)=nat
            end do
         end do
      end do
c
c     F.Mariotti TEST DEBUG Test if needed these lines
c
      nat=0
      do ityp=1,ntyp
         do iat=1,natyp(ityp)
            nat=nat+1
         end do
      end do
c
c     total number of atoms
c
      write(cdummy,'(1X,9A,1X,I4,1X,I4)') ' natoms= ',nat,nnuc
      call cifwrite(cdummy)
c
c     ******************
c     Write ATOM Section
c     ******************
c
      call secwtit(jout,'Atoms',5,' ',0)
      write(jout,'(A8,I3,1x,I3,3F10.4)') (namat(i),i,
     +     nint(elec(i)),(coo(i,j)*angs,j=1,3),i=1,nnuc)
c     F.Mariotti TEST THIS DEBUG
c     +     nint(elec(i)),(coo(i,j)*angs,j=1,3),i=1,nat)
c
c
c     ******************
c     Write STO Section
c     ******************
c
      call secwtit(jout,'STO',3,' ',0)
      call secwcom(jout,' atomo kx ky kz kr alpha bnorm from ADF ',40)
c
      do i=1,naos
         write(jout,'(5I5,2F10.4)') numat(i),(ifunc(i,l),l=1,4),
     &        alpha(i),bnorm(i)
      end do



c
c
      end
