//
// Copyright (C) 1999, 2000, Marco Kesseler
//

implementation module scanbin

import StdInt, StdString, StdList, StdClass, StdMisc, StdEnum
import bits

takeString :: !Int [Char] -> ([Char], !String)
takeString n list = (suffix, toString prefix)
where (prefix, suffix) = splitAt n list

takeInt32 :: [Char] -> ([Char], !Int)
takeInt32 [c1, c2, c3, c4 : list] = (list, chars2int32 c1 c2 c3 c4)
takeInt32 _ = abort "takeInt32: list too short"

takeInt16 :: [Char] -> ([Char], !Int)
takeInt16 [c1, c2 : list] = (list, chars2int16 c1 c2)
takeInt16 _ = abort "takeInt16: list too short"

takeInt8 :: [Char] -> ([Char], !Int)
takeInt8 [c : list] = (list, char2int8 c)
takeInt8 _ = abort "takeInt8: list too short"

take2Int4 :: [Char] -> ([Char], !(!Int, !Int))
take2Int4 [c : list] = (list, char2int4 c)
take2Int4 _ = abort "take2Int4: list too short"

takeListElement :: [a] -> ([a], a)
takeListElement [a : as] = (as, a)
takeListElement [] = abort "takeList: list too short"

takeN_ :: !Int (.s -> (.s, a)) [a] .s -> (.s, [a])
takeN_ n f continue s
| n > 0
	# (s, a)	= f s
	# (s, as)	= takeN_ (n - 1) f continue s
	= (s, [a : as])
	= (s, continue)

//takeN :: !Int (.s -> (.s, a)) .s -> (.s, [a])
takeN n f s :== takeN_ n f [] s

//takeNxN :: !Int !Int (.s -> (.s, a)) .s -> (.s, [[a]])
takeNxN x y f s :== takeN y (takeN x f) s

takeNfromSegments:: !Int !Int (.s -> (.s, a)) [.s] -> [a]
takeNfromSegments n segsize f [seg : segs]
| segsize <= n
	= result
	with (_, result) = takeN_ segsize f (takeNfromSegments (n - segsize) segsize f segs) seg
	= result
	with (_, result) = takeN n f seg
takeNfromSegments n segsize f []
| n == 0
	= []
	= abort "takeNfromSegments: too few segments"

takeSeq :: [((gs,s) -> ((gs,s), a))] (gs,[s]) -> ((gs,[s]), [a])
takeSeq [f : fs] (gs,[s : ss])
	# ((gs,s), a)	= f (gs,s)
	# ((gs,ss), as)	= takeSeq fs (gs,ss)
	= ((gs,[s : ss]), [a : as])
takeSeq [] s
	= (s, [])
takeSeq [f : fs] (gs,[])
	= abort "takeSeq: state list too short"
