//
// Copyright (C) 1999, 2000, Marco Kesseler
//

implementation module imagePlanes

import StdClass, StdChar, StdMisc
import basic, matrix, colourTransform

:: GreyImage :== Matrix Int
:: PlanarColourImage :== [GreyImage]
:: ChunkyColourImage :== Matrix [Int]

:: Image
	= Chunky Int ChunkyColourImage
	| Planar Int PlanarColourImage
	| Grey Int GreyImage
	
	// Special chunky cases
	
	| Chunky3xN Int (Matrix (Int, Int, Int))
	| Chunky4xN Int (Matrix (Int, Int, Int, Int))
	
	| Chunky3x8 GreyImage
	| Chunky4x8 GreyImage
	
//
// At the moment we only support conversion of 8-bit images to character
// lists.
//

imageToCharList :: Image Int Int [Char] -> [Char]
imageToCharList image width height rest
	= case image of
		(Grey 8 image)		-> grey8ImageToCharList image width height rest
		(Chunky 8 image) 	-> chunky8ToCharList image width height rest
		(Chunky3xN 8 image)	-> chunky3x8ToCharList image width height rest
		(Chunky4xN 8 image)	-> chunky4x8ToCharList image width height rest


grey8ImageToCharList :: (Matrix Int) Int Int [Char] -> [Char]
grey8ImageToCharList [row : rows] width height rest
| height > 0
	= rowToCharList row width (grey8ImageToCharList rows width (height - 1) rest)
	= rest
where
	rowToCharList [pixel : pixels] width rest
	| width > 0
		= [toChar pixel : rowToCharList pixels (width - 1) rest]
		= rest
	rowToCharList [] width rest
	| width == 0
		= rest
		= abort "grey8ImageToCharList: image width too small"
	
grey8ImageToCharList [] _ height rest
| height == 0
	= rest
	= abort "grey8ImageToCharList: image height too small"

chunky8ToCharList :: (Matrix [Int]) Int Int [Char] -> [Char]
chunky8ToCharList [row : rows] width height rest
| height > 0
	= rowToCharList row width (chunky8ToCharList rows width (height - 1) rest)
	= rest
where
	rowToCharList [pixel : pixels] width rest
	| width > 0
		= pixToCharList pixel (rowToCharList pixels (width - 1) rest)
		= rest
	rowToCharList [] width rest
	| width == 0
		= rest
		= abort "chunky8ToCharList: image width too small"

	pixToCharList [c : cs] rest
		= [toChar c : pixToCharList cs rest]
	pixToCharList [] rest
		= rest

chunky8ToCharList [] _ height rest
| height == 0
	= rest
	= abort "chunky8ToCharList: image height too small"

chunky3x8ToCharList :: (Matrix (Int,Int,Int)) Int Int [Char] -> [Char]
chunky3x8ToCharList [row : rows] width height rest
| height > 0
	= rowToCharList row width (chunky3x8ToCharList rows width (height - 1) rest)
	= rest
where
	rowToCharList [(a,b,c) : pixels] width rest
	| width > 0
		= [toChar a, toChar b, toChar c : (rowToCharList pixels (width - 1) rest)]
		= rest
	rowToCharList [] width rest
	| width == 0
		= rest
		= abort "chunky3x8ToCharList: image width too small"

chunky3x8ToCharList [] _ height rest
| height == 0
	= rest
	= abort "chunky3x8ToCharList: image height too small"


chunky4x8ToCharList :: (Matrix (Int,Int,Int,Int)) Int Int [Char] -> [Char]
chunky4x8ToCharList [row : rows] width height rest
| height > 0
	= rowToCharList row width (chunky4x8ToCharList rows width (height - 1) rest)
	= rest
where
	rowToCharList [(a,b,c,d) : pixels] width rest
	| width > 0
		= [toChar a, toChar b, toChar c, toChar d : (rowToCharList pixels (width - 1) rest)]
		= rest
	rowToCharList [] width rest
	| width == 0
		= rest
		= abort "chunky4x8ToCharList: image width too small"

chunky4x8ToCharList [] _ height rest
| height == 0
	= rest
	= abort "chunky4x8ToCharList: image height too small"


