//
// Copyright (C) 1999, 2000, Marco Kesseler
//

definition module matrix

//
//	Some standard matrix and vector operations
//

:: Vector a :== [a]
:: Matrix a :== Vector (Vector a)

matMap :: (a -> b) (Matrix a) -> (Matrix b)
matMap2 :: (a b -> c) (Matrix a) (Matrix b) -> (Matrix c)
matMap3 :: (a b c -> d) (Matrix a) (Matrix b) (Matrix c) -> (Matrix d)
matMap4 :: (a b c d -> e) (Matrix a) (Matrix b) (Matrix c) (Matrix d) -> (Matrix e)

matFlatten :: (Matrix (Matrix a)) -> Matrix a

matZip :: [Matrix a] -> Matrix [a]
matZip2 :: [Matrix a] -> Matrix (a, a)
matZip3 :: [Matrix a] -> Matrix (a, a, a)
matZip4 :: [Matrix a] -> Matrix (a, a, a, a)

matUnzip :: (Matrix [a]) -> [Matrix a]

matrixVectorProduct :: (Matrix Real) (Vector Real) -> Vector Real

transpose :: (Matrix a) -> Matrix a
