//
// Copyright (C) 1999, 2000, Marco Kesseler
//

definition module imagePlanes

import matrix, colourTransform

:: Rect :== (!Int, !Int, !Int, !Int)

:: GreyImage :== Matrix Int
:: PlanarColourImage :== [GreyImage]
:: ChunkyColourImage :== Matrix [Int]

:: Image
	= Chunky Int Rect ChunkyColourImage
	| Planar Int Rect PlanarColourImage
	| Grey Int Rect GreyImage
	
	// Special chunky cases
	
	| Chunky3xN Int Rect (Matrix (Int, Int, Int))
	| Chunky4xN Int Rect (Matrix (Int, Int, Int, Int))
	
	| Chunky3x8 Rect GreyImage
	| Chunky4x8 Rect GreyImage
		
imageToCharList :: Image [Char] -> [Char]

