//
// Copyright (C) 1999, 2000, Marco Kesseler
//

definition module bitstream

from bitstream2 import BEBitStream
from bitstream2 import LEBitStream

class BitStream a
where
	getBits	:: a Int -> (Int, a)
	peekBits :: a Int -> (Int, a)
	skipBits :: a Int -> a
	getBitList	:: a [Int]	-> ([Int], a)

	toBitStream :: [Char] -> a
	fromBitStream :: a -> [Char]
	
instance BitStream BEBitStream
instance BitStream LEBitStream

:: WritableBitStream	:== [(Int, Int)]	// list of (nbits, bits)

putLEBits :: WritableBitStream -> [Char]