//
// Copyright (C) 1999, 2000, Marco Kesseler
//

implementation module bits

import StdInt, StdChar, StdArray, StdClass, StdMisc, StdEnum

(bitShiftRight) infix 7
(bitShiftRight) u n :== (u >> n) bitand ((1 << (32 - n)) - 1)

(bitShiftLeft) infix 7
(bitShiftLeft) u n :== u << n

(bitRotateLeft) infix 7
(bitRotateLeft) x n :== (x bitShiftLeft n) bitor (x bitShiftRight (32 - n))

low_bits_mask :: {#Int}
low_bits_mask =: {mask n \\ n <- [0..32]}
where
	mask n = (1 << n) - 1

lowBits b n :== b bitand low_bits_mask.[n]
bit b n :== (b bitand (1 << n)) <> 0

chars2int32 c4 c3 c2 c1 :== ((toInt c4) << 24) bitor ((toInt c3) << 16) bitor ((toInt c2) << 8) bitor (toInt c1)
chars2int16 c2 c1 :== ((toInt c2) << 8) bitor (toInt c1)
char2int8 c :== toInt c
char2int4 c :== ((toInt c) >> 4, lowBits (toInt c) 4)
