/* We assume that  sizeof(int) == (sizeof(int *)) */

#include <stdio.h>
#include <stdlib.h>
#include <orb/orbit.h>
#include "Clean.h"

int __nl_kun_cs_my_orb;
CORBA_exception_type __nl_kun_cs_lastop_exception;
char *__nl_kun_cs_lastop_excname = NULL ;

 static CleanString common_clean_return_value_string;  
 static int ccrvs_is_mallocated = 0;  

int ORB_IIOP_String_to_Object(int orb, CleanString str)
{
  CORBA_Object co;
  CORBA_Environment ev;
  char *str_from_cleanstring;
  str_from_cleanstring = calloc(1,CleanStringLength(str)+1); 
  memcpy(str_from_cleanstring,CleanStringCharacters(str),CleanStringLength(str)); 

  if (__nl_kun_cs_my_orb != orb) {
    fprintf(stderr,"The given ORB object doesnt exists!\n");
  }

  CORBA_exception_init(&ev);
  co = CORBA_ORB_string_to_object((CORBA_ORB) orb, str_from_cleanstring, &ev);
  free(str_from_cleanstring);
  return (int) co;
}



int ORB_IIOP_init(void) {

  int myargc;
  char *myargv[2];

  CORBA_ORB orb;
  CORBA_Environment ev;

  if ((sizeof(CORBA_Object) != sizeof(int)) ||
      (sizeof(CORBA_ORB) != sizeof(int)) ||
      (sizeof(int *) != sizeof(int))) {
    fprintf(stderr,"Type size mismatch!\n");
  }

  myargc=1;
  myargv[0]="CORBA_ORB";
  myargv[1]=NULL;


  CORBA_exception_init(&ev);
  orb = CORBA_ORB_init(&myargc, myargv, "orbit-local-orb", &ev);
  __nl_kun_cs_my_orb= (int) orb;
  return (int) orb;
}


/* --------------- new stuff */


int ORB_IIOP_lastop_exception_code(void)
{
    return __nl_kun_cs_lastop_exception;
}

void ORB_IIOP_lastop_exception_name(CleanString *ret_str_val)
{
 int par_0;
 CORBA_char *rcc=NULL; /* to be able to free the resulting objref */
 char* string_visszateresi_ertek; unsigned int string_v_e_hossz ;
  if (__nl_kun_cs_lastop_exception == CORBA_NO_EXCEPTION) {
    string_visszateresi_ertek =   "NYEMA" ;
  } else {
    string_visszateresi_ertek =  __nl_kun_cs_lastop_excname ;
  }
 string_v_e_hossz = strlen(string_visszateresi_ertek);
 /* result is in : string_visszateresi_ertek, string_v_e_hossz */ 
 if (ccrvs_is_mallocated) {
   free(common_clean_return_value_string); 
 }
 common_clean_return_value_string=malloc(sizeof(int)+1+string_v_e_hossz);
 memcpy((char*)(1+(unsigned int*)common_clean_return_value_string),string_visszateresi_ertek,string_v_e_hossz); ccrvs_is_mallocated = 1;  
 *((unsigned int *)(common_clean_return_value_string)) = string_v_e_hossz;  
 *ret_str_val = common_clean_return_value_string;  
}



