// MSQLResultSet.java
//
// Server side implementation.
//

import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;
import org.omg.CORBA.*;
import java.net.URL;
import java.sql.*;

public class MSQLResultSet extends MSQL._ResultSetImplBase {

  String nevem;
  ORB orbRef;
  ResultSetMetaData oszi;
  ResultSet rs;

   public MSQLResultSet(ORB o, ResultSet rs, String s) {
     orbRef=o;
     nevem=s;
     this.rs=rs;
     try {
      oszi = rs.getMetaData();
     }
     catch( Exception exc ) {
      System.out.println(exc.getMessage());
     }
   }

    public String headername(int column) {
     try {
        return(oszi.getColumnName(column));
     }
     catch( Exception exc ) {
      System.out.println(exc.getMessage());
     }
      return("???COLUMNNAME???");
    }

    public int headerinfo(String info) {
       try {
          if (info.equals("ColumnCount")) {
            return(oszi.getColumnCount());
          }
       }
       catch( Exception exc ) {
        System.out.println(exc.getMessage());
       }
      return(0);
    }

    public String headertype(int column) {
     try {
        return(oszi.getColumnTypeName(column));
     }
     catch( Exception exc ) {
      System.out.println(exc.getMessage());
     }
      return("???COLUMNTYPENAME???");
    }

    public boolean headerisnull(int column) {
     try 
     {
      if (oszi.isNullable(column) == ResultSetMetaData.columnNoNulls) 
      {
        return false;
      } else {
        return true;
      }
     }
     catch( Exception exc ) {
      System.out.println(exc.getMessage());
     }
      return(false);
    }

    public boolean advancecursor(int howmany) {
      boolean x;
      int i;

     try 
     {
       i=howmany;
       x=rs.next();
       while (x && (i > 0)) {
         i=(i-1);
         x=rs.next();
       }
       return x;
     }
     catch( Exception exc ) {
        System.out.println(exc.getMessage());
     }
      return(false);
    }

    public int valuegetint(String fieldname) {
     try 
     {
       return(rs.getInt(fieldname));
     }
     catch( Exception exc ) {
        System.out.println(exc.getMessage());
     }
      return(-1);
    }

    public String valuegetstring(String fieldname) {
     try 
     {
       System.out.println(rs.getString(fieldname));
       return(rs.getString(fieldname));
     }
     catch( Exception exc ) {
        System.out.println(exc.getMessage());
     }
      return("???????VALUE??????");
    }

    public int close() {
      try {
        rs.close();
      } catch (Exception e) { } ;
      System.out.println("CLOSED.\n");
      orbRef.disconnect(this);
      return 1;
    }

    protected void finalize()
    {
      System.out.println("FINALIZED!\n");
    }

}

