/*
 * nodeType.h
 *
 */


typedef enum { typeCon, typeId, typeTypeName, typeOneParam, typeParamList } nodeEnum;

typedef struct {
  nodeEnum type;         /* type of node */
  int value;             /* value of constant */
} conNodeType;

typedef struct {
  nodeEnum type;         /* type of node */
  char *parname;         /* name of the parameter */
  char *partype;         /* type of the parameter */
} onepNodeType;

typedef struct {
  nodeEnum type;         /* type of node */
  onepNodeType **palist; /* pointers to the parameters */
  int howmanyparameters;
} paliNodeType;

typedef struct {
  nodeEnum type;         /* type of node */
  char *name;            /* name of type */
} typeNodeType;

typedef struct {
  nodeEnum type;         /* type of node */
  char *name;            /* name of identifier */
} idNodeType;

typedef union nodeTypeTag {
  nodeEnum type;         /* type of node, but in the tag */
  conNodeType con;
  idNodeType id;
  typeNodeType tp;
  onepNodeType onep;
  paliNodeType pali;
} nodeType;
