module stopwatch

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program creates a window that tracks the elapsed time since startup.
//  For this purpose it uses three timers to track the seconds, minutes, and hours 
//  separately.
//  ********************************************************************************

import StdEnv,StdIO

::  NoState
    =   NoState
::  DialogInfo
    =   {   secondsId   :: Id
        ,   minutesId   :: Id
        ,   hoursId     :: Id
        ,   dialogId    :: Id
        }

second  :== ticksPerSecond
minute  :== 60*second
hour    :== 60*minute

openDialogInfo :: *env -> (DialogInfo,*env) | Ids env
openDialogInfo env
    #   ([secondsid,minutesid,hoursid,dialogid:_],env) = openIds 4 env
    =   (   {   secondsId=secondsid
            ,   minutesId=minutesid
            ,   hoursId  =hoursid
            ,   dialogId =dialogid
            }
        ,   env
        )

Start :: *World -> *World
Start world
    =   startIO NoState NoState [initialise`] [] world
where
    initialise` ps
        #   (dialogInfo,ps) = accPIO openDialogInfo ps
        =   initialise dialogInfo ps

initialise :: DialogInfo (PSt .l .p) -> (PSt .l .p)
initialise {secondsId,minutesId,hoursId,dialogId} ps
    #   (errors,ps)     = seqList [  openTimer 0 (tdef timerinfo)
                                  \\ timerinfo<-[second,minute,hour]
                                  ]  ps
    |   any ((<>) NoError) errors
        =   closeProcess ps
    #   (error,ps)      = openDialog NoState ddef ps
    |   error<>NoError
        =   closeProcess ps
    |   otherwise
        =   ps
where
    tdef timerInterval
        =   Timer timerInterval NilLS [TimerFunction tick]
    where
        tick nrElapsed (time,ps)
            #   time    = (time+nrElapsed) mod (maxunit timerInterval)
            =   (time,setText (textid timerInterval) (toString time) ps)
        
        setText id text ps
            =   appPIO (setWindow dialogId [setControlTexts [(id,text)]]) ps
        
        textid interval
            |   interval==second   = secondsId
            |   interval==minute   = minutesId
            |   interval==hour     = hoursId
        maxunit interval
            |   interval==second   = 60
            |   interval==minute   = 60
            |   interval==hour     = 24
    
    ddef=   Dialog "Stopwatch"
                (   CompoundControl
                (   ListLS  [  TextControl text [ControlPos (Left,zero)]
                            \\ text<-["Hours:","Minutes:","Seconds:"]
                            ]
                )   []
                :+: CompoundControl
                (   ListLS  [  TextControl "00" [ControlPos (Left,zero)
                                                ,ControlId  id]
                            \\ id<-[hoursId,minutesId,secondsId]
                            ]
                )   []
                )
                [   WindowClose (noLS closeProcess)
                ,   WindowId    dialogId
                ]
