module circles

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program creates a window that displays growing concentric circles.
//  For this purpose it uses a timer.
//  ********************************************************************************

import StdEnv, StdIO

::  NoState = NoState

::  TimerState
    =   {   nrCircles       :: Int
        ,   equiDistance    :: Int
        ,   minRadius       :: Int
        }

Start :: *World -> *World
Start world
    #   (windowid,world)    = openId world
    =   startIO NoState NoState [initialise windowid] [] world

initialise windowid ps
    #   (error,ps)      = openMenu NoState mdef ps
    |   error<>NoError
        =   closeProcess ps
    #   (error,ps)      = openWindow NoState wdef ps
    |   error<>NoError
        =   closeProcess ps
    #   (error,ps)      = openTimer initTimerState tdef ps
    |   error<>NoError
        =   closeProcess ps
    |   otherwise
        =   ps
where
    mdef             = Menu "Circles"
                       (   MenuItem "Quit"       [MenuFunction (noLS closeProcess)
                                                 ,MenuShortKey 'q'
                                                 ]
                       )   []
    wdef             = Window "Circles" NilLS
                            [   WindowId         windowid
                            ,   WindowSize       (rectangleSize windowViewDomain)
                            ,   WindowViewDomain windowViewDomain
                            ]
    tdef             = Timer (ticksPerSecond/20) NilLS 
                            [   TimerFunction    timer
                            ]
    windowEdge       = 200
    windowViewDomain = { corner1={x= ~windowEdge/2,y= ~windowEdge/2}
                       , corner2={x=  windowEdge/2,y=  windowEdge/2}
                       }
    initTimerState   = { nrCircles   = 4
                       , equiDistance= 2
                       , minRadius   = 0
                       }
    timer _ (ls=:{nrCircles,equiDistance,minRadius},ps)
        |   minRadius<windowEdge/2
            #   ls          = {ls & minRadius=minRadius+equiDistance}
                newRadius   = minRadius+nrCircles*equiDistance
            #   ps          = appPIO 
                                (drawInWindow windowid
                                [setPenColour White
                                ,draw         {oval_rx=minRadius,oval_ry=minRadius}
                                ,setPenColour Black
                                ,draw         {oval_rx=newRadius,oval_ry=newRadius}
                                ]
                                ) ps
            =   (ls,ps)
        |   otherwise
            #   ps          = appPIO
            					(drawInWindow windowid
                                [setPenColour White,fill windowViewDomain]
                                ) ps
            =   (initTimerState,ps)
