module talk

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program creates two windows that communicate with each other using message 
//	passing. Text that has been typed in one window is being sent to the other, and 
//	vice versa.
//  ********************************************************************************

import  StdEnv, StdIO

::  NoState
    =   NoState

Start :: *World -> *World
Start world
    =   startIO NoState NoState [initialise] [] world
where
    initialise :: (PSt .l .p) -> PSt .l .p
    initialise ps
        #   menu        = Menu "Talk"
                            (   MenuItem "Quit" [   MenuShortKey 'q'
                                                ,   MenuFunction (noLS closeProcess)
                                                ]
                            )   []
        #   (error,ps)  = openMenu undef menu ps
        |   error<>NoError
            =   abort "talk could not open menu."
        #   (a,ps)      = accPIO openRId ps
        #   (b,ps)      = accPIO openRId ps
        #   ps          = openTalkWindow "A" a b ps
        #   ps          = openTalkWindow "B" b a ps
        |   otherwise
            =   ps

openTalkWindow :: String (RId String) (RId String) (PSt .l .p) -> PSt .l .p
openTalkWindow name me you ps
    #   (wId,  ps)  = accPIO openId ps
    #   (inId, ps)  = accPIO openId ps
    #   (outId,ps)  = accPIO openId ps
    #   wdef        = Dialog ("Talk "+++name) 
                        (   EditControl "" (hmm 50.0) 5
                                    [   ControlId       inId
                                    ,   ControlKeyboard inputfilter Able
                                    					(noLS1 (input wId inId you))
                                    ]
                        :+: EditControl "" (hmm 50.0) 5
                                    [   ControlId       outId
                                    ,   ControlPos      (BelowPrev,zero)
                                    ,   ControlSelectState Unable
                                    ]
                        )
                        [   WindowId    wId
                        ]
    #   (error,ps)  = openDialog undef wdef ps
    |   error<>NoError
        =   abort "talk could not open window."
    #   rdef        = Receiver me (noLS1 (receive wId outId)) []
    #   (error,ps)  = openReceiver NoState rdef ps
    |   error<>NoError
        =   abort "talk could not open receiver"
    |   otherwise
        =   ps
where
    inputfilter :: KeyboardState -> Bool
    inputfilter keystate
        =   getKeyboardStateKeyState keystate<>KeyUp
    
    input :: Id Id (RId String) KeyboardState (PSt .l .p) -> PSt .l .p
    input wId inId you _ ps
        #   (Just window,ps) = accPIO (getWindow wId) ps
            text             = fromJust (snd (hd (getControlTexts [inId] window)))
        =   snd (asyncSend you text ps)
        
    receive :: Id Id String (PSt .l .p) -> PSt .l .p
    receive wId outId text ps
        =   appPIO (setWindow wId [ setControlTexts      [(outId,text)]
                                  , setEditControlCursor outId (size text)
                                  ])  ps
