module counterread

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program defines a Controls component that implements a manually settable 
//	counter.
//  A bi-directional receiver is added to give external access to the counter value. 
//  ********************************************************************************

import StdEnv, StdIO

::  NoState
    =   NoState

Start :: *World -> *World
Start world
    =   startIO NoState NoState [initialise] [] world

initialise ps
    #   (windowid, ps)  = accPIO openId   ps
    #   (displayid,ps)  = accPIO openId   ps
    #   (resetid,  ps)  = accPIO openRId  ps
    #   (readid,  ps)   = accPIO openR2Id ps
    #   (error,ps)      = openDialog NoState
    						(dialog windowid displayid resetid readid) ps
    |   error<>NoError
        =   abort "counter could not open counter dialog."
    #   (windowid,ps)   = accPIO openId   ps
    #   (error,ps)      = openDialog NoState (display windowid displayid readid) ps
    |   error<>NoError
        =   abort "counter could not open display dialog."
    |   otherwise
        =   ps
where
    dialog windowid displayid resetid readid
        =   Dialog "Counter" 
                (   counter
                :+: resetbutton
                )
                [   WindowId    windowid
                ,   WindowClose (noLS closeProcess)
                ]
    where
        counter
            =   {   newLS   = initcount
                ,   newDef  = CompoundControl
                              (   EditControl (toString initcount) (hmm 50.0) 1
                                                    [ControlSelectState Unable
                                                    ,ControlPos      (Center,zero)
                                                    ,ControlId       displayid
                                                    ]
                              :+: ButtonControl "-" [ControlFunction (count (-1))
                                                    ,ControlPos      (Center,zero)
                                                    ]
                              :+: ButtonControl "+" [ControlFunction (count   1 )]
                              :+: Receiver  resetid reset []
                              :+: Receiver2 readid  read  []
                              )   []
                }
        where
            initcount = 0
            
            count :: Int (Int,PSt .l .p) -> (Int,PSt .l .p)
            count dx (count,ps)
                #   count   = count+dx
                =   (count,setText windowid displayid count ps)
            
            reset :: m (Int,PSt .l .p) -> (Int,PSt .l .p)
            reset _ (_,ps)
                =   (initcount,setText windowid displayid initcount ps)
            
            read :: m (Int,PSt .l .p) -> (Int,(Int,PSt .l .p))
            read _ (count,ps)
                =   (count,(count,ps))
        
        resetbutton
            =   ButtonControl "Reset" [ControlFunction (noLS reset)
                                      ,ControlPos      (Center,zero)
                                      ]
        where
            reset ps
                =   snd (syncSend resetid undef ps)
    
    display windowid displayid readid
        =   Dialog "Read"
                (   EditControl   "" (hmm 50.0) 1
                                         [ControlSelectState    Unable
                                         ,ControlId             displayid
                                         ]
                :+: ButtonControl "Read" [ControlFunction       (noLS read)
                                         ,ControlPos            (Center,zero)
                                         ]
                )
                [   WindowId    windowid
                ,   WindowClose (noLS closeProcess)
                ]
    where
        read ps
            #   ((error,value),ps)  = syncSend2 readid undef ps
            |   case error of SendOk -> False; _ -> True
                =   abort "could not read counter value"
            |   otherwise
                =   setText windowid displayid (fromJust value) ps
    
    setText :: Id Id x (PSt .l .p) -> PSt .l .p | toString x
    setText wid cid x ps
        =   appPIO (setWindow wid [setControlTexts [(cid,toString x)]]) ps
