module hello

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program creates a dialog that displays "Hello world!" text. 
//  ********************************************************************************

import StdEnv, StdIO

::	NoState
	=	NoState

Start :: *World -> *World
Start world
	=	startIO NoState NoState [initialise] [] world
where
	initialise process
		#	(error,process) = openDialog NoState hello process
		|	error<>NoError
			=	closeProcess process
		|	otherwise
			=	process
	
	hello	= Dialog ""
				(	TextControl "Hello world!" []
				)
				[	WindowClose (noLS closeProcess)
				]
