module usestopwatch

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program creates a simple program that uses the stopwatch process. 
//  The program only has a menu to open the stopwatch and control it.
//  ********************************************************************************

import StdEnv, StdIO
import stopwatch

Start :: *World -> *World
Start world
	# (stopwatchid,world) = openRId world
	= startIO SDI Void (initialise stopwatchid) [] world

initialise :: (RId StopwatchCommands) (PSt .l) -> PSt .l
initialise stopwatchid pst
	# (error,pst)	= openMenu Void mdef pst
	| error<>NoError= closeProcess pst
	| otherwise		= openProcesses (stopwatch stopwatchid) pst
where
	mdef	= Menu "&Stopwatch"
				(	MenuItem "&Reset"	 [MenuFunction (noLS (send Reset))]
				:+:	MenuItem "&Pause"	 [MenuFunction (noLS (send Pause))]
				:+:	MenuItem "C&ontinue" [MenuFunction (noLS (send Continue))]
				:+:	MenuItem "&Close"	 [MenuFunction (noLS (send Close))]
				:+:	MenuSeparator		 []
				:+:	MenuItem "&Quit"	 [MenuFunction (noLS (closeProcess o 
															 (send Close)))]
				) []
	send msg pst
		# (error,pst)	= syncSend stopwatchid msg pst
		| error<>SendOk	= appPIO beep pst
		| otherwise		= pst
