module name_of_program

import StdEnv, StdIO								// Import of standard libraries

::	MyIds											// The record that stores Ids
 =	{	id1		:: Id
 	,	id2		:: Id
 	,	...
 	,	idn		:: Id
 	}
::	MyState											// The local process state
 =	{	myIds	:: MyIds							// contains the MyIds record
 	,	...
 	}
 
openMyIds :: !*env -> (!MyIds,!*env) | Ids env		// openMyIds creates the Ids
openMyIds env
	# ([id1,id2...idn],world)	= openIds n world	// Create n Ids
	= ({id1=id1,id2=id2,...,idn=idn},env)			// Create MyIds record

Start :: *World -> *World
Start world
	# (myIds,world)	= openMyIds world				// Create MyIds record
	# myState		= {...myIds=myIds...}			// in the local process state
	= startIO SDI myState initialise [] world

callback :: (LocalState,PSt MyState) -> (LocalState,PSt MyState)
callback (ls,pst=:{ls={myIds}})						// Every callback function
	= ... myIds.id1 ... myIds.id2 ...				// can now use the Ids
