/*	This Clean program is used to build the object file "gmp.o" which is needed
	to use Clean's ExtendedArith library.
	Originally the GMP library was written for Unix systems. The build process worked
	as follows: For every GMP function there was a single ".c" file. These files were
	compiled seperately into several object files which were linked into a library.
	At the time of writing the ExtendedArith library there was no possibility to link
	libraries (here: collections of object files) with the Clean linker. We wanted
	to have the code for all needed functions within _one_ object file. So we wrote
	the gmp.c file which #include-d all needed ".c" files. But this did not work for
	the necessary hand writeen GMP assembly files. So we first compile the gmp.c file
	to an assembly text	file. The purpose of this program is to append the additional
	hand written GMP assembly files to this text file. Therefore it is necessary to
	_rename_ the labels in the appended files.
	
*/

module mergeAssemblyFiles

import StdEnv

mpn :== "gmp-2.0.2\\mpn\\tmp-"
assemblyNames :== ["add_n.s","addmul_1.s", "lshift.s", "mul_1.s", "rshift.s"
					, "sub_n.s", "submul_1.s"]

Start w
	= mergeAssemblyFiles "gmp2.s" [mpn+++file_name \\ file_name<-assemblyNames ] w

mergeAssemblyFiles fname fnames w
	# (ok, file1, w) = fopen fname FAppendText w
	| not ok
		= abort ("mergeAssemblyFiles: can't open file "+++fname)
	# (_, file1, w) = foldSt addFile fnames (0, file1, w)
	  (_, w) = fclose file1 w
	= w
	
read_all_labels accu f
	# (next_label, f) = read_next_label f
	| size next_label==0
		= (accu, f)
	= read_all_labels [next_label:accu] f

read_next_label f
	# (isEof, f) = fend f
	| isEof
		= ("", f)
	# (line, f) = freadline f
	  size_line = size line
	| size_line<3
		= read_next_label f
	| line.[0]<>'L'
		= read_next_label f
	# colon_pos = lookup ":" line
	| colon_pos<0
		= read_next_label f
	= (line % (0,colon_pos-1), f)

addFile :: !String !(!Int, !*File, !*World) -> (!Int, !.File, !.World)
addFile fileName (count, output, w)
	# (ok, input, w) = fopen fileName FReadText w
	| not ok
		= abort ("mergeAssemblyFiles: can't open file "+++fileName)
	# (new_labels, input) = read_all_labels [] input
	  (ok, input) = fseek input FSeekSet 0
	| not ok
		= abort "mergeAssemblyFiles: seek failed"
	# sorted_labels = sortBy (\ l1 l2->size l1>size l2) new_labels
	  label_mapping = [ (old_label, old_label+++"R"+++toString i)
	  					\\ old_label<-sorted_labels & i<-[count..] ]
	  (count, input, output) = append_with_renamed_labels label_mapping count input output
	  (_, w) = fclose input w
	= (count+length new_labels, output, w)
	
append_with_renamed_labels label_mapping count input output
	# (isEof, input) = fend input
	| isEof
		= (count, input, output)
	# (line, input) = freadline input
	  line = foldSt replace_label label_mapping line
	  output = fwrites line output
	= append_with_renamed_labels label_mapping count input output

replace_label :: !(!String, !String) !String -> String
replace_label mapping=:(old, new) line
	# pos = lookup old line
	| pos<0
		= line
	= replace_label mapping (line % (0, pos-1)+++new+++line % (pos+(size old), (size line)-1))

lookup :: !String !String -> Int
lookup substr str
	= lkup  0 ((size str)-(size substr)) substr str
  where
	lkup i max substr str
		| i>max
			= (-1)
		| (str % (i, i+(size substr)-1))==substr && not (isAlphanum str.[i+(size substr)])
			= i
		= lkup (inc i) max substr str
	
foldSt op l st :== fold_st l st
	where
		fold_st [] st		= st
		fold_st [a:x] st	= fold_st x (op a st)
