module testDirectory

import StdEnv, Directory

:: Platforms = UnixPlatform | WindowsPlatform | MacPlatform

tempDir :== "tempDir"
f       :== "f"
g       :== "g"
dir     :== "dir"

Start w
    # (io, w) = stdio w
    # (platform, w) = getPlatform w
      root = case platform of
                UnixPlatform -> RelativePath []
                WindowsPlatform -> RelativePath []
                MacPlatform -> RelativePath [] //AbsolutePath "Temp" []
    # (io, w) = test platform root io w
    #! w = w
    # (io, w) = print_a_directory io w
    = (io, w)
    
print_a_directory io w
    # ((errCode, dirContents), w) = getDirectoryContents (RelativePath []) w
    | errCode<>NoDirError
        = fail 0
    # io = foldSt fwrites ["The test program now prints the current directory's contents\n",
                            "which you might want to check.\n\n"] io
      maxNameLength = foldl max 0 [size fileName \\ {fileName}<-dirContents] 
    # io = foldSt (print_dir_contents maxNameLength) dirContents io
    =  (io, w)

test platform root io w
    # temp = appendPath root [PathDown tempDir]
      ((errCode, fileinfo), w) = getFileInfo temp w
    | errCode==NoDirError
        # (temp_string, _) = pathToPD_String temp w
        = abort ("\nerror: The test program expects, that a file named \""+++temp_string+++"\" does _not_\n"
                +++"exist in the current directory. It has been found that this assumption\n"
                +++"has been violated. So remove that file manually and run the test program\n"
                +++"(called \"testDirectory\") once again.\n")
    # (errCode, w) = createDirectory temp w
    | errCode<>NoDirError
        = fail 2
    # (errCode, w) = createDirectory temp w
    | errCode<>AlreadyExists
        = fail 3
    # (errCode, w) = createDirectory (appendPath temp [PathDown "dir", PathDown "dir"]) w
    | errCode<>DoesntExist
        = fail 4
    = testGetDirectoryContents platform root temp io w

testGetDirectoryContents platform root temp io w
    # temp_f = appendPath temp [PathDown f]
      ((errCode, _), w) = getDirectoryContents temp_f w
    | errCode<>DoesntExist
        = fail 6
    # (temp_f_string, w) = pathToPD_String temp_f w
      (ok, file, w) = fopen temp_f_string FWriteText w
    | not ok
        = fail 7
    # file = fwrites "f" file
      (ok, w) = fclose file w
    | not ok
        = fail 8
    # temp_dir = appendPath temp [PathDown dir]
      (errCode, w) = createDirectory temp_dir w
    | errCode<>NoDirError
        = fail 9
    # ((errCode, _), w) = getDirectoryContents temp w
    | errCode<>NoDirError
        = fail 10
    = testFmove platform root temp temp_dir temp_f io w   

testFmove platform root temp temp_dir temp_f io w
    # temp_g = appendPath temp [PathDown g]
      (temp_g_string, w) = pathToPD_String temp_g w
      (ok, file, w) = fopen temp_g_string FWriteText w
//    w = test_removing_open_file platform temp_g w
    | not ok
        = fail 11
    # file = fwrites "g" file
      (ok, w) = fclose file w
    | not ok
        = fail 12
    # temp_dir_g = appendPath temp_dir [PathDown g]
      (errCode, w) = fmove OverwriteFile temp_g temp_dir_g w
    | errCode<>NoDirError
        = fail 13
    # (errCode, w) = fmove OverwriteFile temp_g temp_dir_g w
    | errCode<>DoesntExist
        = fail 14
    # (errCode, w) = fmove DontOverwrite temp_f temp_dir_g w
    | errCode<>AlreadyExists
        = fail 15
    # (errCode, w) = fmove OverwriteFile temp_f temp_dir w
    | errCode<>AlreadyExists
        = fail 16
    # (errCode, w) = fmove OverwriteFile temp_f temp_dir_g w
    | errCode<>NoDirError
        = fail 17
    # ((errCode, _), w) = getFileInfo temp_f w
    | errCode==NoDirError
        = fail 18
    # (errCode, w) = fmove OverwriteFile temp (appendPath temp_dir [PathDown "down"]) w
    | errCode<>MoveIntoOffspring
        = fail 19
    = testFremove platform root temp temp_dir temp_f temp_g temp_dir_g io w

testFremove platform root temp temp_dir temp_f temp_g temp_dir_g io w
    # (errCode, w) = fremove temp_dir_g w
    | errCode<>NoDirError
        = fail 20
    # (errCode, w) = fremove temp_f w
    | errCode<>DoesntExist
        = fail 21
    # (errCode, w) = fremove temp w
    | errCode<>NotYetRemovable
        = fail 22
    # (errCode, w) = fremove temp_dir w
    | errCode<>NoDirError
        = fail 23
    = testCurrentDir platform root temp temp_dir temp_f temp_g temp_dir_g io w


testCurrentDir platform root temp temp_dir temp_f temp_g temp_dir_g io w
    # (errCode, w) = setCurrentDirectory temp_dir w
    | errCode<>DoesntExist
        = fail 24
    # (errCode, w) = setCurrentDirectory temp w
    | errCode<>NoDirError
        = fail 25
    # (absolute_temp=:(AbsolutePath _ p), w) = getCurrentDirectory w
      (PathDown td) = last p
    | td<>tempDir
        = fail 26
    # (errCode, w) = setCurrentDirectory (appendPath absolute_temp [PathUp]) w
    | errCode<>NoDirError
        = fail 27
    # (errCode, w) = fremove absolute_temp w
    | errCode<>NoDirError
        = fail 28
    = (io, w)
    
getPlatform :: *World -> (Platforms, *World)
getPlatform w
    # ((_, [{fileInfo={pd_fileInfo}}:_]), w)
        = getDirectoryContents (RelativePath []) w
    = (case pd_fileInfo of
        Unix _      -> UnixPlatform
        Windows _   -> WindowsPlatform
        Mac _       -> MacPlatform
      ,w
      )

appendPath (AbsolutePath diskName path) path2 = AbsolutePath diskName (path++path2)
appendPath (RelativePath path) path2 = RelativePath (path++path2)

foldSt op l st :== fold_st l st
    where
        fold_st [] st       = st
        fold_st [a:x] st    = fold_st x (op a st)

print_dir_contents maxNameLength 
                {fileName, fileInfo={pi_fileInfo={fileSize,lastModified=(date,time),isDirectory}}} io
    = foldSt fwrites [fileName,toString (spaces (maxNameLength-(size fileName))), " size:",
                        toString (toInt fileSize),"\t",toString date, "\t", toString time,
                        "\tisDirectory:", toString isDirectory,"\n"] io

instance toString Date`
  where
    toString {day`, month`, year`} = toString day`+++"."+++toString month`+++". "+++toString year`

instance toString Time`
  where
    toString {hours`, minutes`} = toString hours`+++":"+++toString minutes`

fail nr
    = abort ("\nThe test program detected an error while testing the Directory module.\n"
             +++"Please write an email to martinw@cs.kun.nl and include in that mail\n"
             +++"that error number "+++toString nr+++" has been detected.\n")
