// ************************************************************
//	Clean Linear Algebra Subroutines - CLAS
//	Version 0.6 - February 23, 1998 - Thorsten Zoerner
// 	Catholic University of Nijmegen - zoerner@cs.kun.nl
// ************************************************************

definition module Clas2

import Clas1, SampleMat

class MatrixVectorProduct a
where
	(**) infix 7 :: a .Vector -> .Vector
	
instance MatrixVectorProduct {# {# Real}}

// instance MatrixVectorProduct {# Int}			// Permutes a vector
// not allowed in Clean

transpose 		:: .Matrix -> .Matrix

perVec 			:: {# Int} .Vector -> .Vector	// Permutes a vector

forwardSubst 	:: Matrix Vector -> *Vector		// Solves a system
												// with a lower left
												// triangular system *)
backwardSubst 	:: Matrix Vector -> *Vector		// Solves a system
												// with a upper right
												// triangular system 
// To be used with LU factorization Ax=LUx=b <==> Ly=b, Ux=y,
// or LU factorization with partial pivoting PAx=LUx=Pb <==> Ly=Pb, Ux=y.
// (cf. solve and solvePartPiv in Clas3)

// *)	assuming that only ones are on the diagonal, which is the case 
//		after the LU factorization

