// ************************************************************
//	Clean Linear Algebra Subroutines - CLAS
//	Version 0.5 - October 6, 1998 - Thorsten Zoerner
// 	Catholic University of Nijmegen - zoerner@cs.kun.nl
// ************************************************************

implementation module Clas2

import Clas1, SampleMat, StdMisc

class MatrixVectorProduct a
where
	(**) infix 7 :: a Vector -> Vector
	
instance MatrixVectorProduct {#{# Real}}
where
	(**) a x = { dot aa x \\ aa <-: a}

transpose :: .Matrix -> .Matrix
transpose a = transpose_i 0 (zeroMatrix m n)
where
	n = size a
	m = size a.[0]
	transpose_i :: Int *Matrix -> *Matrix
	transpose_i i b
		| (i==m) = b
		= transpose_i (inc i) { b & [i] = { a.[j,i] \\ j <- [0 .. (dec n)]}}  

forwardSubst :: Matrix Vector -> *Vector
forwardSubst l b = forwardSubst_ 1 { zeros n & [0] = b.[0] / l.[0, 0]}
where
	n = size l
	forwardSubst_ :: Int *Vector -> *Vector
	forwardSubst_ i y
		#! dotly = dot l.[i] y
		| (i==dec n) = { y & [i] = b.[i] - dotly }
		= forwardSubst_ (inc i) { y & [i] = b.[i] - dotly }

backwardSubst :: Matrix Vector -> *Vector
backwardSubst u y = backwardSubst_ (n-2) { zeros n & [dec n] = (y.[dec n] / u.[dec n, dec n]) }
where
	n = size u
	backwardSubst_ :: Int *Vector -> *Vector
	backwardSubst_ i x 
		#! dotux = dot u.[i] x
		| (i==0) = {x & [i] = (y.[i] - dotux) / u.[i,i]}
		= backwardSubst_ (dec i) {x & [i] = (y.[i] - dotux) / u.[i,i]}

