definition module deltaIOState

import deltaIOSystem
from ioTypes import IOState

/*	ObscureCursor hides the cursor until the mouse is moved. */
ObscureCursor :: !(IOState s) -> IOState s

/*	Set the shape of the cursor globally. This shape overrules the local cursor
	shapes of windows. */
SetGlobalCursor :: !CursorShape !(IOState s) -> IOState s


/*	Undoes the effect of SetGlobalCursor. */
ResetCursor :: !(IOState s) -> IOState s

:: DoubleDownDist :== Int
SetDoubleDownDistance :: !DoubleDownDist !(IOState s) -> IOState s
/*	Set the maximum distance the mouse is allowed to move to generate a
	ButtonDouble(Triple)Down button state. Negative values are set to zero. */
