implementation module deltaSystem

import clCrossCall, StdString

UpKey     :== '\036'
DownKey   :== '\037'
LeftKey   :== '\034'
RightKey  :== '\035'
PgUpKey   :== '\013'
PgDownKey :== '\014'
BeginKey  :== '\001'
EndKey    :== '\004'
BackSpKey :== '\010'
DelKey    :== '\177'
TabKey    :== '\011'
ReturnKey :== '\015'
EnterKey  :== '\003'
EscapeKey :== '\033'
HelpKey   :== '\005'


ShiftOnly   :== (True,False,False,False)
OptionOnly  :== (False,True,False,False)
CommandOnly :== (False,False, True,True)
ControlOnly :== (False,False, True,True)


TheAppPath =: path 
where
   ptr       = WinGetAppPath 
   (path, _) = WinGetCStringAndFree ptr 99


DirSeparator :== '\\'

HomePath :: !String -> String
HomePath s = TheAppPath +++ s 

ApplicationPath :: !String -> String
ApplicationPath s = TheAppPath +++ s

MaxScrollWindowSize :: (!Int,!Int)
MaxScrollWindowSize = WinMaxScrollWindowSize

MaxFixedWindowSize :: (!Int,!Int)
MaxFixedWindowSize = WinMaxFixedWindowSize

MMToHorPixels :: !Real -> Int
MMToHorPixels mm = InchToHorPixels (mm/25.4)

MMToVerPixels :: !Real -> Int
MMToVerPixels mm = InchToVerPixels (mm/25.4)

InchToHorPixels :: !Real -> Int
InchToHorPixels inch = toInt ( inch * toReal WinGetHorzResolution)

InchToVerPixels :: !Real -> Int
InchToVerPixels inch = toInt ( inch * toReal WinGetHorzResolution)

