implementation module deltaIOState

import intrface
import ioTypes, StdString, clCrossCall
import Events
from Window0 import FindWindowWithHandle

Void :== 0

ObscureCursor :: !(IOState s) -> IOState s
ObscureCursor iostate = PackIOState adm newos
where
  (adm, os) = UnpackIOStateWithCheck iostate
  newos     = WinObscureCursor os



:: DoubleDownDist :== Int

SetDoubleDownDistance :: !DoubleDownDist !(IOState s) -> IOState s
SetDoubleDownDistance d iostate = PackIOState adm newos
where
  (adm, os) =  UnpackIOStateWithCheck iostate
  newos     =  WinSetDoubleDownDist d os



SetGlobalCursor :: !CursorShape !(IOState s) -> IOState s
SetGlobalCursor shape iostate = PackIOState adm newos
where
  (adm, os)    =  UnpackIOStateWithCheck iostate
  cursorcode   =  CursorShape2Code shape
  setcci       =  ( CcRqSETGLOBALCURSOR, cursorcode, 0,0,0,0,0 )
  (_,_, newos) =  IssueCleanRequest (ErrorCallback "SetGlobalCursor") setcci Void os



ResetCursor :: !(IOState s) -> IOState s
ResetCursor iostate = PackIOState adm newos
where
  (adm, os)    =  UnpackIOStateWithCheck iostate
  resetcci     =  ( CcRqRESETCURSOR, 0,0,0,0,0,0 )
  (_,_, newos) =  IssueCleanRequest (ResetCallback adm) resetcci Void os

  ResetCallback adm (CcWmSETCURSOR, hwnd, _,_,_,_,_) s os 
    = case FindWindowWithHandle hwnd adm.io_windowState of
		Nope      -> ( False, Return0Cci, s, os)
		OK window -> ( True,  returncci,  s, os)
			where
			  returncci   =  Return1Cci (CursorShape2Code window.wcursor)
  ResetCallback adm cci s os = (True, Return0Cci, s, os)

