definition module MineTypes

import StdInt, StdFile
import deltaPicture, deltaFont, deltaWindow
import Random

::	Minefield	:==	[[Spot]]
::	Spot		=	Mine		Visibility
				|	Empty Int	Visibility
::	Visibility	=	Visible
				|	Invisible
::	Pebbles		:==	[Position]
::	Position	:==	(!Int,!Int)
::	Time		=	Running Int
				|	Off
::	Dimension	:==	(!Int,!Int)
::	*MinesBest	:==	(Files,BestTimes)
::	BestTimes	:== (ThreeBest, ThreeBest, ThreeBest)
::	ThreeBest	:== (String,Int,String,Int,String,Int)
     
EasyDim			:== (8,  8)
EasyMines		:== 10
InterDim		:== (16,16)
InterMines		:== 40
HardDim			:== (30,16)
HardMines		:== 99

SizeArea		:== 14

GetTime					:: !Time -> Int

DrawCorrectnessPebble	:: Pebbles Position !Spot	!Picture -> Picture

DrawNrMines				:: !Font !Int !Dimension	!Picture -> Picture
DrawTime				:: !Font !Int !Dimension	!Picture -> Picture
DrawEmptyArea			:: !Position				!Picture -> Picture
DrawPebble				:: !Position				!Picture -> Picture
DrawSpot				:: !Position !Spot			!Picture -> Picture
DrawAnySpot				:: !Position !Spot			!Picture -> Picture
DrawGrid				:: !Dimension				!Picture -> Picture

SowMines				:: !Int !Dimension !RandomSeed	-> (!Minefield,!RandomSeed)
GetSpot					:: !Position !Minefield			-> Spot
RevealSpot				:: !Position !Minefield			-> (!Spot,!Minefield)

NulSpot					:: !Spot -> Bool
MineSpot				:: !Spot -> Bool
InvisibleSpot			:: !Spot -> Bool

RemovePebble			:: !Position !Pebbles	-> Pebbles

WindowPictDomain		:: !Dimension			-> PictureDomain
MaxDimension			:: Dimension		
TranslatePoint			:: !Point !Vector		-> Point
