definition module deltaIOSystem


//
// Common types for the event I/O system.
//

from StdString import String
from picture import Point, Rectangle, UpdateArea, DrawFunction, Picture


  //-------------------------------------------------//
 //  The IO System                                  //
//-------------------------------------------------//


/*
:: IOSystem *s *io :== [ DeviceSystem s io ]

:: DeviceSystem *s *io =  MenuSystem   [MenuDef   s io]
				 		| TimerSystem  [TimerDef  s io]
						| WindowSystem [WindowDef s io]
						| DialogSystem [DialogDef s io]

*/
from ioTypes import IOSystem, DeviceSystem, MenuSystem, TimerSystem, WindowSystem, DialogSystem

  //-------------------------------------------------//
 //  Common type definitions                        //
//-------------------------------------------------//


/*

:: ItemTitle     :== String

:: SelectState =  Able | Unable
:: MarkState   =  Mark | NoMark

:: KeyboardState :== (!KeyCode, !KeyState, !Modifiers)
:: KeyCode       :== Char
:: KeyState      =  KeyUp | KeyDown | KeyStillDown

:: MouseState    :== (!MousePosition, !ButtonState, !Modifiers)
:: MousePosition :== (!Int, !Int)
:: ButtonState   =  ButtonUp | ButtonDown | ButtonDoubleDown |
                    ButtonTripleDown | ButtonStillDown

/* Modifiers indicates the meta keys that have been pressed (TRUE)
   or not (FALSE): (Shift, Alternate/Meta, Control, Control)
*/

:: Modifiers     :== (!Bool,!Bool,!Bool,!Bool)

:: PictureDomain :== Rectangle

*/

from ioTypes import ItemTitle,
                    SelectState, Able, Unable,
					MarkState, Mark, NoMark,
                    KeyboardState, KeyCode,
					KeyState, KeyUp, KeyDown, KeyStillDown,
					MouseState, MousePosition,
					ButtonState, ButtonUp, ButtonDown, ButtonDoubleDown, ButtonTripleDown, ButtonStillDown,
					Modifiers, PictureDomain

  //----------------------------------------------//
 //  The type definitions for the menu device.   //
//----------------------------------------------//


/*
:: MenuDef *s *io
       =  PullDownMenu MenuId MenuTitle SelectState [MenuElement s io]

:: MenuElement *s *io
         =  MenuItem MenuItemId ItemTitle KeyShortcut SelectState (MenuFunction s io)
         |  CheckMenuItem MenuItemId ItemTitle KeyShortcut SelectState MarkState
                          (MenuFunction s io)
         |  SubMenuItem MenuId ItemTitle SelectState [MenuElement s io]
         |  MenuItemGroup MenuItemGroupId [MenuElement s io]
         |  MenuRadioItems MenuItemId [RadioElement s io]
         |  MenuSeparator

:: RadioElement *s *io
       =  MenuRadioItem MenuItemId ItemTitle KeyShortcut SelectState
                        (MenuFunction s io)


:: MenuTitle             :== String
:: MenuFunction *s *io   :== !s -> *( !io -> (s, io)) 
:: MenuId                :== Int
:: MenuItemId            :== Int
:: MenuItemGroupId       :== Int
:: KeyShortcut           =  Key KeyCode | NoKey
*/

from ioTypes import MenuDef, PullDownMenu,
                    MenuElement, MenuItem, CheckMenuItem, SubMenuItem,
					MenuItemGroup, MenuRadioItems, MenuSeparator,  
					RadioElement, MenuRadioItem,
                    MenuTitle, MenuFunction, 
					MenuId, MenuItemId, MenuItemGroupId,
					KeyShortcut, Key, NoKey

  //------------------------------------------------//
 //  The type definitions for the window device.   //
//------------------------------------------------//



/*

:: WindowDef * s * io
   =  ScrollWindow WindowId WindowPos WindowTitle
                   ScrollBarDef ScrollBarDef
                   PictureDomain MinimumWindowSize InitialWindowSize
                   (UpdateFunction s) [WindowAttribute s io]
   |  FixedWindow  WindowId WindowPos WindowTitle
                   PictureDomain
                   (UpdateFunction s)  [WindowAttribute s io]
 
:: WindowId          :== Int
:: WindowPos         :== (!Int, !Int)
:: WindowTitle       :== String

:: ScrollBarDef      =  ScrollBar ThumbValue ScrollValue
:: ThumbValue        =  Thumb  Int
:: ScrollValue       =  Scroll Int
:: MinimumWindowSize :== (!Int, !Int)
:: InitialWindowSize :== (!Int, !Int)

:: UpdateFunction * s      :== UpdateArea -> s -> (s,[DrawFunction]) 
 
:: WindowAttribute * s * io =
      Activate   (WindowFunction s io)
   |  Deactivate (WindowFunction s io)
   |  GoAway     (WindowFunction s io)
   |  Mouse      SelectState (MouseFunction    s io)
   |  Keyboard   SelectState (KeyboardFunction s io)
   |  Cursor     CursorShape
   |  StandByWindow 

:: WindowFunction   * s * io :== s ->  *(io -> (s, io) )
:: KeyboardFunction * s * io :== KeyboardState ->  s ->  *(io -> (s, io))  
:: MouseFunction    * s * io :== MouseState ->     s ->  *(io -> (s, io))  
 

:: CursorShape =  StandardCursor | BusyCursor     | IBeamCursor |
                  CrossCursor    | FatCrossCursor | ArrowCursor | HiddenCursor
				      
*/

from ioTypes import WindowDef, ScrollWindow, FixedWindow,
             WindowId, WindowPos, WindowTitle,
             ScrollBarDef, ScrollBar,
			 ThumbValue, Thumb, ScrollValue, Scroll, 
			 MinimumWindowSize, InitialWindowSize,
			 UpdateFunction,
			 WindowAttribute, Activate, Deactivate, GoAway,
			 Mouse, Keyboard, Cursor, StandByWindow,
			 WindowFunction, KeyboardFunction, MouseFunction,
			 CursorShape, StandardCursor, BusyCursor, IBeamCursor,
			 CrossCursor, FatCrossCursor, ArrowCursor, HiddenCursor

  //----------------------------------------------//
 //  The type definitions for the timer device.  //
//----------------------------------------------//


/*
:: TimerDef * s * io		=  Timer TimerId SelectState TimerInterval (TimerFunction s io)
:: TimerId      			:== Int
:: TimerInterval			:== Int
:: TimerFunction * s * io	:== TimerState ->  s -> *( io -> (s,io) ) 
:: TimerState    			:== Int
*/

from ioTypes import TimerDef, Timer, TimerId, TimerInterval, TimerFunction,
                    TimerState


  //------------------------------------------------//
 //  The type definitions for the dialog device.   //
//------------------------------------------------//

/*
:: * DialogState * s * io 
:: DialogInfo 


:: DialogDef * s * io
   =  PropertyDialog DialogId DialogTitle [DialogAttribute] (SetFunction s io)
                     (ResetFunction s io) [DialogItem s io]
   |  CommandDialog  DialogId DialogTitle [DialogAttribute]
                     DialogItemId [DialogItem s io]
   |  AboutDialog    ApplicationName PictureDomain [DrawFunction]
                     (AboutHelpDef s io)

:: ApplicationName :== String
:: AboutHelpDef * s * io = NoHelp
                           | AboutHelp ItemTitle (AboutHelpFunction s io)
:: AboutHelpFunction * s * io :== s ->  *(io -> (s,io)) 

:: DialogAttribute
   =  DialogPos    Measure Measure
   |  DialogSize   Measure Measure
   |  DialogMargin Measure Measure
   |  ItemSpace    Measure Measure
   |  StandByDialog

:: DialogId    :== Int
:: DialogTitle :== String
:: Measure     =  MM Real | Inch Real | Pixel Int
 
:: DialogItem * s * io
   =  DialogButton DialogItemId ItemPos ItemTitle SelectState (ButtonFunction s io)
   |  DialogIconButton DialogItemId ItemPos PictureDomain IconLook SelectState (ButtonFunction s io)
   |  StaticText   DialogItemId ItemPos String
   |  DynamicText  DialogItemId ItemPos TextWidth String
   |  EditText     DialogItemId ItemPos TextWidth NrEditLines String
   |  DialogPopUp  DialogItemId ItemPos SelectState DialogItemId [RadioItemDef s io]
   |  RadioButtons DialogItemId ItemPos RowsOrColumns DialogItemId [RadioItemDef s io]
   |  CheckBoxes   DialogItemId ItemPos RowsOrColumns [CheckBoxDef s io]
   |  Control      DialogItemId ItemPos PictureDomain SelectState ControlState
                       ControlLook ControlFeel (DialogFunction s io)
 
:: DialogItemId  :== Int
:: RowsOrColumns =  Rows Int | Columns Int
:: ItemPos       =  Left | Center | Right        |
                    RightTo DialogItemId         |
                    Below DialogItemId           |
                    XOffset DialogItemId Measure |
                    YOffset DialogItemId Measure |
                    XY Measure Measure           |
                    ItemBox Int Int Int Int
:: IconLook      :== SelectState -> [DrawFunction]
:: TextWidth     :== Measure
:: NrEditLines   :== Int
:: RadioItemDef * s * io =  RadioItem DialogItemId ItemTitle SelectState (DialogFunction s io)
:: CheckBoxDef * s * io  =  CheckBox DialogItemId ItemTitle SelectState MarkState (DialogFunction s io)
 
:: ControlState =  IntCS    Int                       |
                   BoolCS   Bool                      |
                   RealCS   Real                      | 
                   StringCS String                    |
                   PairCS   ControlState ControlState |
                   ListCS   [ControlState]
:: ControlLook :== SelectState ->  ControlState -> [DrawFunction] 
:: ControlFeel :== MouseState ->   ControlState -> (ControlState,[DrawFunction]) 
 
:: SetFunction    * s * io :== ButtonFunction s io
:: ResetFunction  * s * io :== ButtonFunction s io
:: DialogFunction * s * io :== DialogInfo -> (DialogState s io) -> DialogState s io
:: ButtonFunction *s *io :== DialogInfo -> ( s -> * (io -> (s,io)))

 
:: NoticeDef       =  Notice [String] NoticeButtonDef [NoticeButtonDef]
:: NoticeButtonDef =  NoticeButton NoticeButtonId ItemTitle
:: NoticeButtonId  :== Int

*/

from ioTypes import DialogState, PropertyDialog, AboutDialog, CommandDialog,
                    DialogInfo, DialogDef, ApplicationName,
					AboutHelpDef, NoHelp, AboutHelp, AboutHelpFunction,
					DialogAttribute, DialogPos, DialogSize, DialogMargin,
					ItemSpace, StandByDialog, DialogId, DialogTitle,
					Measure, MM, Inch, Pixel,
					DialogItem, DialogButton, DialogIconButton, StaticText,
					DynamicText, EditText, DialogPopUp, RadioButtons, CheckBoxes, 
					Control, DialogItemId, RowsOrColumns, Rows, Columns,
					ItemPos, Left, Center, Right, RightTo, Below, XOffset, YOffset,
					XY, ItemBox, 
					IconLook, TextWidth, NrEditLines, RadioItemDef, RadioItem,
					CheckBoxDef, CheckBox, 
					ControlState, IntCS, BoolCS, RealCS, StringCS, PairCS, ListCS,
					ControlLook, ControlFeel,
					SetFunction, ResetFunction, DialogFunction,
					ButtonFunction, NoticeDef, Notice, NoticeButtonDef, NoticeButton,
					NoticeButtonId
