module CalcDialog;

/*	A simple desk calculator using a dialog for the calculator.

	Run the program using the "No Console" option (Application options).

	To generate an application for this program the memory of the Clean
	0.8 application should be set to at least 1600K.
	The linker needs an additional 500K of free memory inside or outside
	the Clean 0.8 application.
	To launch the generated application 550K of free memory is needed
	outside the Clean 0.8 application.
*/

import StdEnv, deltaEventIO, deltaDialog, deltaFont, deltaPicture;

    
::	* State	:== (String, Operation, String);
::	* IO		:==  IOState State;
::	Operation	:== Int ->  Int -> Int ;
    
Start	:: * World -> * World;
Start world = CloseEvents events` world`;
		where {
		(state, events`)=: StartIO io_system ("0",K,"") [] events;
		(events, world`)=: OpenEvents world;
		io_system       =: [DialogSystem [Dialog], MenuSystem [Menu]];
		};

Menu	::    MenuDef State IO;
Menu = PullDownMenu FileId "File" Able [
					MenuItem IdR "Open Calculator" (Key 'O') Able Open,
					MenuItem IdQ "Quit"            (Key 'Q') Able Quit];

Dialog	::    DialogDef State IO;
Dialog = CommandDialog CalcId "Calculator" atts Id_eq [
				  		DialogIconButton IdNum Center NumDom (NumLook "0") Unable DoNothing,
				  		CalcButton Id7 (YOffset IdNum (Pixel 12)) "7"   font (NumBut 7),
				  		CalcButton Id8   (RightTo Id7)            "8"   font (NumBut 8),
				  		CalcButton Id9   (RightTo Id8)            "9"   font (NumBut 9),
				  		CalcButton IdC   (RightTo Id9)            "C"   font Clear,
				  		CalcButton Id4    Left                    "4"   font (NumBut 4),
				  		CalcButton Id5   (RightTo Id4)            "5"   font (NumBut 5),
				  		CalcButton Id6   (RightTo Id5)            "6"   font (NumBut 6),
				  		CalcButton Id_mul   (RightTo Id6)            "*"   font (DiOp (*)),
				  		CalcButton Id1    Left                    "1"   font (NumBut 1),
				  		CalcButton Id2   (RightTo Id1)            "2"   font (NumBut 2),
				  		CalcButton Id3   (RightTo Id2)            "3"   font (NumBut 3),
				  		CalcButton Id_min   (RightTo Id3)            "-"   font (DiOp (-)),
				  		CalcButton Id0    Left                    "0"   font (NumBut 0),
				  		CalcButton Id_div__div__min (RightTo Id0)            "+/-" font PlusMin,
				  		CalcButton Id_eq   (RightTo Id_div__div__min)          "="   font Becomes,
				  		CalcButton Id_div   (RightTo Id_eq)            "+"   font (DiOp (+))];
				  where {
				  atts=: [DialogMargin (Pixel 4) (Pixel 4),
				         ItemSpace    (Pixel 4) (Pixel 4)];
				  (b,font)=: SelectFont "Geneva" [] 9;
				  };

DoNothing	:: DialogInfo State IO -> (State, IO);
DoNothing dialog state io =  (state, io);

NumLook	:: String SelectState -> [DrawFunction];
NumLook num abty =  [MovePenTo (4,13), DrawString num, DrawRectangle NumDom];

CalcButton	:: DialogItemId ItemPos ItemTitle Font (ButtonFunction State IO) -> DialogItem State IO;
CalcButton id pos title font bfunc
	=  DialogIconButton id pos ButDom (ButLook font title) Able bfunc;

ButLook	:: Font ItemTitle SelectState -> [DrawFunction];
ButLook font title abty =  [SetFont font, FillRectangle ((2,2),(ButWid,ButHgt)),
	                            EraseRectangle butrect, DrawRectangle butrect, 
	                            MovePenTo (x,11), SetPenMode OrMode, DrawString title];
		where {
		butrect=: ((0,0),(ButWid - 2,ButHgt - 2));
		x=: dec ((ButWid -  FontStringWidth title font ) / 2);
		};

//	The button function for the 0,1,2...9 buttons

NumBut	:: Int DialogInfo State IO -> (State, IO);
NumBut num dialog (arg1, op, arg2) io
	| arg2 == "" =  ((num1, op, arg2), ChangeNumber num1 io);
	=  ((arg1, op, num2), ChangeNumber num2 io);
		where {
		num1=: div_Digit arg1 num;
		num2=: div_Digit arg2 num;
		};

//	The button function for the Clear button

Clear	:: DialogInfo State IO -> (State, IO);
Clear dialog nr io =  (("0", K, ""), ChangeNumber "0" io);

//	The button function for the '+' button

DiOp	:: (Int ->  Int -> Int ) DialogInfo State IO -> (State, IO);
DiOp operator dialog nr=:(arg1,op,arg2) io
	| arg2 == "" =  ((arg1, operator, "0"), io);
	= 	(nr, Beep io);

//	The button function for the '+/-' button

PlusMin	:: DialogInfo State IO -> (State, IO);
PlusMin dialog (arg1, op, arg2) io
	| arg2 == "" =  ((neg1, op, arg2), ChangeNumber neg1 io);
	=  ((arg1, op, neg2), ChangeNumber neg2 io);
		where {
		(is_neg1, neg1)=: IsNegative arg1;
		(is_neg2, neg2)=: IsNegative arg2;
		};

//	The button function for the '=' button

Becomes	:: DialogInfo State IO -> (State, IO);
Becomes dialog (arg1, op, arg2) io
	=  ((result, K, ""), ChangeNumber result io);
		where {
		result=: toString (op (STRINGToINT arg1) (STRINGToINT arg2));
		};

//	Change the number in the calculator

ChangeNumber	:: String IO -> IO;
ChangeNumber num io =  ChangeDialog CalcId [ChangeIconLook IdNum (NumLook num)] io;

//	Open the Calculator

Open	:: State IO -> (State, IO);
Open state io =  (state, OpenDialog Dialog io);

//	Quit the calculator

Quit	:: State IO -> (State, IO);
Quit state io =  (state, QuitIO io);


     
	CalcId :== 1;	IdNum :== 11;										IdQ :== 16;
	FileId :== 1;	Id7 :== 7;		Id8	:== 8;		Id9 :== 9;	IdC :== 12;
	IdR	 :== 17;	Id4 :== 4;		Id5	:== 5;		Id6 :== 6;	Id_mul :== 13;
						Id1 :== 1;		Id2	:== 2;		Id3 :== 3;	Id_min :== 18;
						Id0 :== 10;		Id_div__div__min	:== 15;	Id_eq :== 14;	Id_div :== 19;
	NumDom	:== ((0,0),(105,17));
	ButDom	:== ((0,0),(ButWid,ButHgt));
	ButWid	:== 28;
	ButHgt	:== 16;

    
/* Primitive functions. */

IsNegative	:: !String -> (!Bool, !String);
IsNegative arg
	|  arg.[0]  == '-' = 	(True,  arg % (1, (dec (size arg))));
	= 	(False, "-" +++ arg);

STRINGToINT	:: !String -> Int;
STRINGToINT arg
	| is_negative = 	0 -  STRINGToINT` arg` 0 ;
	= 	STRINGToINT` arg 0;
		where {
		(is_negative, arg`)=: IsNegative arg;
		};

STRINGToINT`	:: !String !Int -> Int;
STRINGToINT` "" nr =  nr;
STRINGToINT` arg nr
	= 	STRINGToINT` arg` ( 10 * nr  + digit);
		where {
		arg` =: arg % (1, dec (size arg));
		digit=:  toInt (arg.[0])  -  toInt '0' ;
		};

div_Digit	:: !String !Int -> String;
div_Digit arg nr |  size arg  >= 12 =  arg;
div_Digit "0" nr =  toString nr;
div_Digit arg nr =  arg +++  toString nr ;
