implementation module ioState

import ostypes, oskernel
import StdEnv
import deltaIOSystem
import dialogDef
from dialogDevice import IsAboutDialog

:: * IOState * s   =	{io_menu	:: CurrentMenuSystem s,
		  				 io_states	:: [DeviceSystemState s],
		  				 io_events	:: !EVENTS,
		  				 io_about	:: AboutDialogDef s 
						}

::   * EVENTS       :== Int

:: DeviceSystemState * s
		= TimerSystemState       (TimerHandles s (IOState s))
	|  WindowSystemState      (WindowHandles s)
	|  MenuSystemState        (MenuHandles   s (IOState s))
	|  DialogSystemState      (DialogHandles s (IOState s))

/*  The timer handles. */

:: TimerHandles * s * io :== [TimerHandle s io]
:: TimerHandle * s * io  :== (!TimerPtr, TimerId, !TimerInterval, TimerFunction s io)

// The window handles.

:: WindowHandles * s :== [WindowHandle s]
:: WindowHandle  * s :== (!WindowDef s (IOState s), !Window)
:: Window           :== (!WindowPtr, PicturePtr, ScrollState, ScrollState, !CursorPtr, !Offset)
:: ScrollState      = {	scroll_ptr	:: !ControlPtr,
					    scroll_line	:: !Int,
					    scroll_page	:: !Int,
					    scroll_min	:: !Int,
					    scroll_max	:: !Int,
					    scroll_div	:: !Int
					  }
:: Offset           :== (!Int, !Int)

/*  Menu handles */

:: MenuHandles * s * io    :== [MenuHandle s io]
:: MenuHandle  * s * io
		= PullDownHandle MenuPtr MenuId MenuId MenuTitle SelectState [MenuItemHandle s io]
:: MenuItemHandle * s * io
		= ItemHandle        MenuPtr MenuItemId MenuItemId ItemTitle KeyShortcut SelectState (MenuFunction s io)
	|  CheckItemHandle   MenuPtr MenuItemId MenuItemId ItemTitle KeyShortcut SelectState MarkState (MenuFunction s io)
	|  SubItemHandle     MenuPtr MenuItemId MenuId ItemTitle SelectState [MenuItemHandle  s io]
	|  ItemGroupHandle   MenuPtr MenuItemGroupId [MenuItemHandle  s io]
	|  RadioItemsHandle  MenuItemId MenuItemId [MenuItemHandle s io]
	|  SeparatorHandle   MenuPtr MenuItemId

// The dialog handles

:: DialogHandles * s * io   :== [DialogHandle s io]

/* this part is special for OS2 */

/* Int is the last system_id given out */
:: CurrentMenuSystem * s    = NoCurMenu
                            | CurMenu !(MenuHandles s (IOState s)) ![ShortCut] !SelectState !Int

:: AboutDialogDef * s = NoAbout
	| About (DialogDef s (IOState s))

:: ShortCut = ShortCutHandle ShortCutPtr MenuItemId MenuItemId Char SelectState
	|  SubShortCuts MenuItemId MenuItemId SelectState [ShortCut]

/* end of OS2 part */

:: Device = TimerDevice | MenuDevice | WindowDevice | DialogDevice

:: DeviceFunctions * s :== (!ShowFunction  s,
														 !OpenFunction  s,
														 !DoIOFunction  s,
														 !CloseFunction s,
														 !HideFunction  s)

:: ShowFunction * s :== (IOState s) ->  IOState s 
:: HideFunction * s :== (IOState s) ->  IOState s 
:: OpenFunction * s :== (DeviceSystem s (IOState s)) -> *( (IOState s) ->  IOState s ) 
:: DoIOFunction  * s :== Event -> *( s ->  *((IOState s) -> (Bool, s, IOState s)))  
:: CloseFunction * s :== (IOState s) ->  IOState s 

DummyEvents :== 0

OpenEvents :: !* World -> (!EVENTS, !* World)
OpenEvents world = (DummyEvents, world)
/*
   -> UEvaluate_2 (OpenEvents1 world) (OpenToplevelX (InitToplevelX 0))
*/

CloseEvents :: !EVENTS !* World -> * World
CloseEvents events world = world
/*
   -> UEvaluate_2 (CloseEvents1 events world) (CloseToplevelX 0)
*/

/*
:: OpenEvents1 !UNQ WORLD -> (!EVENTS, !UNQ WORLD)
		  OpenEvents1 world
   ->   OpenEvents2 (StoreWorld (OR% w 2) world), IF = 0 (AND% 2 w)
   ->   ABORT "OpenEvents: This world doesn't contain events",
		  w: LoadWorld world

::   OpenEvents2 !UNQ WORLD -> (!EVENTS, !UNQ WORLD)
		  OpenEvents2 w -> CODE 
		  pushI 0
   

::   LoadWorld !WORLD -> INT
		  LoadWorld w -> CODE 
		  pushI_a 0
		  pop_a 1
   

::   StoreWorld !INT !WORLD -> UNQ WORLD
		  StoreWorld i w -> CODE 
		  pop_a 1
		  pop_b 1
		  instruction -1039777792 || ld     [%i1], %g1
		  instruction -534372348  || st     %l0, [%i0 + 0x4]
		  instruction -1037697024 || st     %g1, [%i0]
   

::   CloseEvents1 !EVENTS !UNQ WORLD -> UNQ WORLD
		  CloseEvents1 e world
   ->   CloseEvents2 e (StoreWorld (AND% (LoadWorld world) -3) world)

::   CloseEvents2 !EVENTS !UNQ WORLD -> UNQ WORLD
		  CloseEvents2 e w -> CODE 
		  pop_b 1
		  fill_a 0 1
		  pop_a 1
   
*/

/*   Creation rules for IOStates: */

NewIOStateFromOld :: !(IOState s) -> (!IOState t, !IOState s);
NewIOStateFromOld {io_menu,io_states,io_events,io_about=about}
		=  (EmptyIOState io_events, {io_menu=io_menu,io_states=io_states,io_events=DummyEvents,io_about=about});

EmptyIOState :: !EVENTS -> IOState s;
EmptyIOState es
		= {io_menu=NoCurMenu,io_states=[],io_events=es,io_about=NoAbout};

OldIOStateFromNew :: !(IOState s) !(IOState t) -> IOState s;
OldIOStateFromNew {io_menu,io_states,io_about=about} {io_events}
		= {io_menu=io_menu,io_states=io_states,io_events=io_events,io_about=about};

IOStateEvents :: !(IOState s) -> EVENTS;
IOStateEvents {io_events}
		=  io_events;

IOStateClosed :: !(IOState s) -> (!Bool, !IOState s);
IOStateClosed io=:{io_menu=NoCurMenu}
	=  (True, io);
IOStateClosed io=:{io_states}
	| CheckOpenWindows io_states || CheckOpenDialogs io_states
		= (False, io)
		= (True, io)

CheckOpenWindows    :: ![DeviceSystemState s] -> Bool
CheckOpenWindows devs
	| not (DevicesHasDevice devs WindowDevice)
		= False
		= NoEmptyWindowDevice (DevicesGetDevice devs WindowDevice)
	where
		NoEmptyWindowDevice :: !(DeviceSystemState s) -> Bool
		NoEmptyWindowDevice (WindowSystemState []) = False
		NoEmptyWindowDevice windows = True

CheckOpenDialogs :: ![DeviceSystemState s] -> Bool
CheckOpenDialogs devs
	| not (DevicesHasDevice devs DialogDevice)
		= False
		= NoEmptyDialogDevice (DevicesGetDevice devs DialogDevice)
	where
		NoEmptyDialogDevice :: !(DeviceSystemState s) -> Bool
		NoEmptyDialogDevice (DialogSystemState dialogs) = HasRealDialog dialogs;

				HasRealDialog [] = False;
				HasRealDialog [dialog : dialogs]
					| IsAboutDialog dialog
						= HasRealDialog dialogs;
						= True;

IOStateGetAnyDevice :: !(IOState s) -> (!DeviceSystemState s, !IOState s)
IOStateGetAnyDevice io=:{io_states=[d : ds]}
		= (d, io)

IOStateSetDevice :: !(IOState s) !(DeviceSystemState s) -> IOState s
IOStateSetDevice io d
		= let! 
			strict1
		  in {io & io_states = strict1} 
		  where 
		  priority=: Priority (DeviceSystemStateToDevice d)
		  strict1=SetDevice io.io_states priority d

IOStateGetCurrentMenu :: !(IOState s) -> (!CurrentMenuSystem s, ! IOState s)
IOStateGetCurrentMenu io_state=:{io_menu}
		= (io_menu, io_state)

IOStateSetCurrentMenu :: (CurrentMenuSystem s) !(IOState s) -> IOState s
IOStateSetCurrentMenu menu io
		= {io & io_menu = menu}

SetDevice :: ![DeviceSystemState s] !Int !(DeviceSystemState s)
   -> [DeviceSystemState s]
SetDevice [WindowSystemState x : ds] priority d=:(WindowSystemState x`)
		= [d : ds]
SetDevice [MenuSystemState   x : ds] priority d=:(MenuSystemState x`) 
		= [d : ds]
SetDevice [DialogSystemState x : ds] priority d=:(DialogSystemState x`)
		= [d : ds]
SetDevice [TimerSystemState  x : ds] priority d=:(TimerSystemState x`)
		= [d : ds]
SetDevice ds=:[sorted_d : sorted_ds] priority d
	| priority >  Priority (DeviceSystemStateToDevice sorted_d)
		= [d : ds]
		= let! strict1
		  in [sorted_d : strict1]
		  where 
		  strict1=SetDevice sorted_ds priority d		
SetDevice ds priority d = [d]

IOStateGetDevice    :: !(IOState s) !Device -> (!DeviceSystemState s, !IOState s)
IOStateGetDevice io=:{io_menu=CurMenu menus cuts state i} MenuDevice
		= (MenuSystemState menus, io)
IOStateGetDevice {io_states=[]} device
		= abort "Can't perform any event I/O operations on an empty IOState\n"
IOStateGetDevice iostate=:{io_states} d
		= (DevicesGetDevice io_states d, iostate)

DevicesGetDevice :: ![DeviceSystemState s] !Device -> DeviceSystemState s
DevicesGetDevice [d=:WindowSystemState x : ds] WindowDevice   = d
DevicesGetDevice [d=:MenuSystemState   x : ds] MenuDevice     = d
DevicesGetDevice [d=:DialogSystemState x : ds] DialogDevice   = d
DevicesGetDevice [d=:TimerSystemState  x : ds] TimerDevice    = d
DevicesGetDevice [d : ds] device = DevicesGetDevice ds device
DevicesGetDevice ds device = abort "Device not present in IOState.\n"

IOStateRemoveDevice :: !(IOState s) !Device -> IOState s
IOStateRemoveDevice io d
		= let!
			strict1
		  in {io & io_states = strict1}
		  where  strict1=DevicesRemoveDevice io.io_states d

DevicesRemoveDevice :: ![DeviceSystemState s] !Device -> [DeviceSystemState s]
DevicesRemoveDevice [WindowSystemState  x : ds] WindowDevice = ds
DevicesRemoveDevice [MenuSystemState    x : ds] MenuDevice   = ds
DevicesRemoveDevice [DialogSystemState  x : ds] DialogDevice = ds
DevicesRemoveDevice [TimerSystemState   x : ds] TimerDevice  = ds
DevicesRemoveDevice [d` : ds] d
		= let! 
			strict1
		  in [d` : strict1]
		  where 
		  strict1=DevicesRemoveDevice ds d
DevicesRemoveDevice ds d = ds

IOStateHasDevice :: !(IOState s) !Device -> (!Bool, !IOState s)
IOStateHasDevice iostate=:{io_states} d
		= (DevicesHasDevice io_states d, iostate)

DevicesHasDevice :: ![DeviceSystemState s] !Device -> Bool
DevicesHasDevice [d=:TimerSystemState   x : ds] TimerDevice  = True
DevicesHasDevice [d=:MenuSystemState    x : ds] MenuDevice   = True
DevicesHasDevice [d=:WindowSystemState  x : ds] WindowDevice = True
DevicesHasDevice [d=:DialogSystemState  x : ds] DialogDevice = True
DevicesHasDevice [d` : ds] d = DevicesHasDevice ds d
DevicesHasDevice ds d = False

IOStateSetAbout:: (AboutDialogDef s) !(IOState s) -> IOState s
IOStateSetAbout about io=:{io_about}
		= {io & io_about = about}

IOStateGetAbout:: !(IOState s) -> (!AboutDialogDef s, ! IOState s)
IOStateGetAbout io_state=:{io_about}
		= (io_about,io_state)

/* Access-rules on Devices: */

DeviceSystemStateToDevice :: !(DeviceSystemState s) -> Device
DeviceSystemStateToDevice (WindowSystemState x) = WindowDevice
DeviceSystemStateToDevice (MenuSystemState   x) = MenuDevice
DeviceSystemStateToDevice (DialogSystemState x) = DialogDevice
DeviceSystemStateToDevice (TimerSystemState  x) = TimerDevice

Priority :: !Device     -> Int
Priority MenuDevice     = 4
Priority TimerDevice    = 3
Priority DialogDevice   = 2
Priority WindowDevice   = 1
