system module StdReal

// ****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.1
//	Copyright 1995 University of Nijmegen
// ****************************************************************************************

import	StdOverloaded

instance +				Real
instance -				Real
instance zero			Real

instance *				Real
instance /				Real
instance one			Real

instance ^				Real
instance abs			Real
instance sign			Real
instance ~				Real

instance ==				Real

instance <  			Real

instance toInt			Real
instance toReal			Real
instance toString		Real

instance fromReal		Int
instance fromReal		Real
instance fromReal		{#Char}

//	Logarithmical Functions:

ln					:: !Real 		->	Real	//	Logarithm base e
log10				:: !Real 		->	Real	//	Logarithm base 10
exp					:: !Real 		->	Real	//	e to to the power	
sqrt				:: !Real 		->	Real	//	Square root

//	Trigonometrical Functions:

sin					:: !Real		->	Real	//	Sinus
cos					:: !Real		->	Real	//	Cosinus
tan					:: !Real		->	Real	//	Tangens
asin				:: !Real		->	Real	//	Arc Sinus
acos				:: !Real		->	Real	//	Arc Cosinus
atan				:: !Real		->	Real	//	Arc Tangus

//	Additional conversion:

entier				:: !Real		->	Int		//	Cconvert Real into Int by taking entier
