implementation module wormshow;

import	StdClass;
import StdFile, StdInt, deltaPicture, deltaIOSystem;


     

	PointsPos	:== (72,15);
	LifesPos	:== (255,5);
	LevelPos	:== (465,15);
	CornerX		:== 15;
	CornerY		:== 23;
	SizeX		:== 45;
	SizeY		:== 26;
	SegSize		:== 4;
	CellSize	:== 10;


    

//	The Program State.

::	Grow			:== Int;
::	Obstacle		:== (Int,Int,Int,Int);
::	Level			:== (Int,Int,Int,Obstacle,Obstacle);
::	Food			:== (Int,Int,Int);
::	Segment			:== (Int,Int);
::	Worm			:== [Segment];
::	Points			:== Int;
::	Direction		:== Char;
::	* HiScores	:== (Files,Highs);
::	Highs			:== [(String,Points)];
::	Lifes			:== Int;
::	* State		:== * (Level, Food, Grow, Points, Direction, Worm, HiScores, Lifes, RandomSeed);
::	RandomSeed	:== Int;


    

//	Erase the game.

EraseGame	:: Picture -> Picture;
EraseGame pict
	= 	EraseRectangle ((CornerX - 8, 0), (rx + 16, by + 16)) pict;
	where {
	rx=: CornerX +  SizeX * CellSize ;
	by=: CornerY +  SizeY * CellSize ;
	};

//	Draw the game.

DrawGame	:: Level Food Points Worm Lifes -> [DrawFunction];
DrawGame (fix, speed, level, obs1, obs2) food points worm lifes
	=  [SetWormFont, DrawBorders obs1 obs2, DrawPoints points, DrawWorm worm,
		             DrawFood food        , DrawLevel level  , DrawLifes lifes];

DrawBorders	:: Obstacle Obstacle Picture -> Picture;
DrawBorders obs1 obs2 pict =  pict5;
	where {
	pict1=: SetPenSize (3,3) pict;	
	pict2=: DrawRectangle ((CornerX - 3, CornerY - 3), (rx + 11, by + 11)) pict1;
	pict3=: ObstacleRect obs1 pict2;
	pict4=: ObstacleRect obs2 pict3;
	pict5=: SetPenNormal pict4;	
	rx=: CornerX +  SizeX * CellSize ;
	by=: CornerY +  SizeY * CellSize ;
	};

ObstacleRect	:: Obstacle Picture -> Picture;
ObstacleRect (0,0,0,0) pict =  pict;
ObstacleRect (ltx,lty,rbx,rby) pict
	= 	DrawRectangle ((lx,ty),(rx,by)) pict;
	where {
	lx=:  CornerX +  CellSize * ltx   - 2;
	ty=:  CornerY +  CellSize * lty   - 2;
	rx=:  CornerX +  CellSize * rbx   + 2;
	by=:  CornerY +  CellSize * rby   + 2;
	};

DrawPoints	:: Points Picture -> Picture;
DrawPoints points pict
	= 	DrawNewPoints points pict3;
	where {
	pict1=: SetPenColour MagentaColour pict;
	pict2=: DrawString "Points: " (MovePenTo (x - 57, y) pict1);
	pict3=: SetPenColour BlackColour pict2;
	(x,y)=: PointsPos;
	};

DrawWorm	:: Worm Picture -> Picture;
DrawWorm [head:rest] pict
	= 	SetPenColour BlackColour face;
	where {
	face =: DrawSegment GreenColour head worm;
	worm =: DrawSegments rest pict;
	};

DrawSegments	:: Worm Picture -> Picture;
DrawSegments [] pict =  pict;
DrawSegments [seg : rest] pict
	= 	DrawSegments rest (DrawSegment RedColour seg pict);

DrawSegment	:: Colour Segment Picture -> Picture;
DrawSegment color (x,y) pict =  FillCircle ((cx,cy),SegSize) pict1;
	where {
	pict1=: SetPenColour color pict;
	cx=: CornerX +  CellSize * x ;
	cy=: CornerY +  CellSize * y ;
	};

EraseSegment	:: Segment Picture -> Picture;
EraseSegment segment pict =  DrawSegment WhiteColour segment pict;

DrawFood	:: Food Picture -> Picture;
DrawFood (pts, fx, fy) pict =  pict3;
	where {
	pict1=: SetPenColour MagentaColour pict;
	pict2=: FillRectangle ((x, y), (x + 6, y + 6)) pict1;
	pict3=: SetPenColour BlackColour pict2;
	x=: CornerX + ( CellSize * fx  - 3);
	y=: CornerY + ( CellSize * fy  - 3);
	};
	
EraseFood	:: Food Picture -> Picture;
EraseFood (pts, fx, fy) pict
	= 	EraseRectangle ((x, y), (x + 6, y + 6)) pict;
	where {
	x=: CornerX + ( CellSize * fx  - 3);
	y=: CornerY + ( CellSize * fy  - 3);
	};

DrawLevel	:: Int Picture -> Picture;
DrawLevel level pict
	= 	DrawNewLevel level pict3;
	where {
	pict1=: SetPenColour MagentaColour pict;
	pict2=: DrawString "Level: " (MovePenTo (x - 50, y) pict1);
	pict3=: SetPenColour BlackColour pict2;
	(x,y)=: LevelPos;
	};

DrawLifes	:: Lifes Picture -> Picture;
DrawLifes 0 pict =  SetPenColour BlackColour pict2;
	where {
	pict1=: SetPenColour MagentaColour pict;
	pict2=: DrawString "No more worms!" (MovePenTo (lx - 63, ly + 10) pict1);
	(lx,ly)=: LifesPos;
	};
DrawLifes lifes pict =  DrawLittleWorms lifes pict;

DrawLittleWorms	:: Lifes Picture -> Picture;
DrawLittleWorms 0 pict =  SetPenColour BlackColour pict2; 
	where {
	pict1=: SetPenColour MagentaColour pict;
	pict2=: DrawString "Worms:" (MovePenTo (lx - 63, ly + 10) pict1);
	(lx,ly)=: LifesPos;
	};
DrawLittleWorms life pict =  DrawLittleWorms (dec life) (DrawLittleWorm life pict);

DrawLittleWorm	:: Int Picture -> Picture;
DrawLittleWorm n pict =  SetPenNormal pict3;
	where {
	pict1=: SetPenColour RedColour (SetPenSize (4,5) pict);
	pict2=: LinePenTo (x + 9, y) (MovePenTo (x,y) pict1);
	pict3=: LinePenTo (x + 10, y) (SetPenColour GreenColour pict2);
	x      =: lx +  20 * ( dec n  / 2) ;
	y      =: ly +  7 * ( dec n  mod 2) ;
	(lx,ly)=: LifesPos;
	};


//	Show a step of the worm.

DrawStep	:: Bool Food Food Points Segment Segment Segment Picture -> Picture;
DrawStep False o f p oldh head tail pict =  DrawMove oldh head tail pict;
DrawStep scored oldf food points oldh head tail pict =  pict3;
	where {
	pict1=: DrawNewFood oldf food pict;
	pict2=: DrawNewPoints points pict1;
	pict3=: DrawMove oldh head tail pict2;
	};

DrawMove	:: Segment Segment Segment Picture -> Picture;
DrawMove oldh head (0,0) pict =  SetPenColour BlackColour pict2;
	where {
	pict1=: DrawSegment RedColour oldh pict;
	pict2=: DrawSegment GreenColour head pict1;
	};
DrawMove oldh head tail pict =  SetPenColour BlackColour pict3;
	where {
	pict1=: DrawSegment RedColour oldh pict;
	pict2=: DrawSegment GreenColour head pict1;
	pict3=: DrawSegment WhiteColour tail pict2;
	};

DrawNewPoints	:: Points Picture -> Picture;
DrawNewPoints points pict =  DrawString (toString points) (MovePenTo PointsPos erase);
	where {
	erase=: EraseRectangle ((dec x, y - 12), (x + 100, y + 4)) pict;
	(x,y)=: PointsPos;
	};

DrawNewLevel	:: Int Picture -> Picture;
DrawNewLevel level pict =  DrawString (toString level) (MovePenTo LevelPos erase);
	where {
	erase=: EraseRectangle ((dec x, y - 12), (x + 100, y + 4)) pict;
	(x,y)=: LevelPos;
	};

DrawNewFood	:: Food Food Picture -> Picture;
DrawNewFood oldf food pict =  DrawFood food (EraseFood oldf pict);

//	Set the font of the worm game.

SetWormFont	:: Picture -> Picture;
SetWormFont pict =  SetFontSize 12 (SetPenColour BlackColour pict);

//	Close the Playfield between two levels.

DrawAnimation	:: Int Int Picture -> Picture;
DrawAnimation 40 1 pict
	=  SetPenColour BlackColour (DrawBorders r r (SetPenColour WhiteColour pict));
	where {
	r=:(0,0,0,0);
		
	};
DrawAnimation n s pict
	| s < 0 = 	DrawRectangle ((l,t),(r,b)) (EraseRectangle ((r,t),(x,y))
		           (EraseRectangle ((l,b),(x,y)) (SetPenSize (3,3) pict)));
	= 	DrawRectangle ((l,t),(r,b)) (EraseRectangle ((r,t),(x - 3,y))
		           (EraseRectangle ((l,b),(x,y - 3)) (SetPenSize (3,3) pict)));
	where {
	l=: CornerX - 3;  t=: CornerY - 3;
	r=: l +  w * n ;  b=: t +  h * n ;
	x=: r -  s * w ;  y=: b -  s * h ;
	w=: (48 +  SizeX * CellSize ) / 40;
	h=: (48 +  SizeY * CellSize ) / 40;
	};
