definition module StdClassList

//	****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.0
//	Copyright 1995 University of Nijmegen
//	****************************************************************************************

from StdClass import Eq, Ord, PlusMin, Arith, FromInt

//	When ordering is defined on list elements

maxList		:: !.[a] 		-> a 		| Ord a	//	Maximum element of list
minList		:: !.[a] 		-> a 		| Ord a	//	Minimum element of list
sort		:: !u:[a] 		-> u:[a] 	| Ord a	//	Sort the list
merge		:: !.[a] !u:[a] -> u:[a] 	| Ord a	//	Merge two sorted lists giving a sorted list

//	When equality is defined on list elements

isMember		::    a	!.[a]	-> .Bool 	| Eq a	//	Is element in list
removeMembers	:: u:[a] .[a] 	-> u:[a] 	| Eq a	//	Remove arg2s from list arg1
removeDup		:: !.[a] 		-> .[a] 	| Eq a	//	Remove all duplicates from list

limit			:: !.[a] 		-> a 		| Eq a	//	[...,a,a]

//	When addition is defined on list elements

sum		:: !.[a] -> a 	| PlusMin a			//	sum of list elements, sum [] = zero

//	When multiplication and addition is defined on list elements

prod	:: !.[a] -> a 	| Arith a				//	product of list elements, prod [] = one
avg		:: !.[a] -> a 	| Arith a & FromInt a	//	average of list elements, avg [] gives error!
