implementation module EdFiles;

/*	File I/O routines for the editor.
*/

import	StdClass;
import StdInt, StdString, StdBool, StdChar, StdFile, deltaSystem;

import EdDialogs, EdProgramState;

     
	NewlineChar	:== '\n';

    

//
//	Read a file
//

ReadFile	:: Pathname Editor -> (Editor, Text, NrLines, Bool);
ReadFile path editor
	| success =  let! {
		strict1;
		} in
		(strict1, text, nrlines, True);
	=  let! {
		strict2;
		} in
		(editor`, EmptyText, 1, False);
	where {
	(editor`,success,file)=: OpenUFile path FReadText editor;
	(list,nrlines,file`)  =: strict2;
	text                  =: Text_StringsToText list;
	strict2=ReadLinesFromFile file;
		strict1=CloseUFile file` editor`;
		};

ReadLinesFromFile	:: UFILE -> (![String], !Int, !UFILE);
ReadLinesFromFile file
	| sfend fil1 =  (last, nr, fil1);
	=  let! {
		strict1;
		rest;
		} in
		([strict1 : rest], inc nrlines, newf);
	where {
	(rest, nrlines, newf)=: ReadLinesFromFile fil1;
	(string, fil1)			=: freadline file;
	(last,nr)				=: LastStrings string;
	strict1=ReplaceLastChar string;
		};

LastStrings	:: String -> (![String], !Int);
LastStrings "" =  ([NewlStr], 1);
LastStrings str
	| NewlineChar ==  str !!  dec (# str)   =  ([str,NewlStr],2);
	=  let! {
		strict1;
		} in
		([strict1],1);
	where {
	strict1=str +++ NewlStr;
		
	};

ReplaceLastChar	:: String -> String;
ReplaceLastChar str =  str := (dec (# str), NewlStr !! 0);

//
// Save a file
//

SaveFile	:: Pathname Text Editor -> (Editor, Bool);
SaveFile path text editor
	| open =  let! {
		strict1;
		} in
		(strict1, report);
	=  (editor`, False);
	where {
	(editor`,open,file)=: OpenUFile path FWriteText editor;
	(error,file`)      =: ferror (WriteToFile text file);
	report          	 =: open &&  not error ;
	strict1=CloseUFile file` editor`;
		}; 

WriteToFile	:: Text !UFILE -> UFILE;
WriteToFile [block] file =  WriteLastBlockToFile block file;
WriteToFile [block:blocks] file
	=  WriteToFile blocks (WriteBlockToFile block file);

WriteBlockToFile	:: Block !UFILE -> UFILE;
WriteBlockToFile [] file =  file;
WriteBlockToFile [line:lines] file
	=  WriteBlockToFile lines (fwrites (ResetNewlineChar line) file);

WriteLastBlockToFile	:: Block !UFILE -> UFILE;
WriteLastBlockToFile [line] file =  fwrites laststr file;
	where {
	laststr=: StripNewline (ResetNewlineChar line);
	};
WriteLastBlockToFile [line:lines] file
	=  WriteLastBlockToFile lines (fwrites (ResetNewlineChar line) file);

ResetNewlineChar	:: TLine -> String;
ResetNewlineChar line =  str := (dec (# str), NewlineChar);
	where {
	str=: Line_LineToString line;
	};

StripNewline	:: String -> String;
StripNewline string | lmin1 < 0 =  "";
	                    =  string % (0, dec lmin1);
	where {
	lmin1=:(dec (# string));
		
	};

//
//	Read the default settings
//

ReadDefaultSettings	:: Editor -> Editor;
ReadDefaultSettings editor
	| not open =  editor`;
	=  let! {
		strict1;
		} in
		SetDefaults defs (strict1);
	where {
	(defs,file`)       =: ReadDefaults file;
	(editor`,open,file)=: OpenUFile PrefsPath FReadText editor;
	strict1=CloseUFile file` editor`;
		};

ReadDefaults	:: UFILE -> (Defaults, UFILE);
ReadDefaults file =  ((tabs,(font,size),auto),file`);
	where {
	tabs=: Between 1 99 (ConvertToNumber tabsstr);
	font=: ConvertToString fontstr;
	size=: Between MinFontSize MaxFontSize (ConvertToNumber sizestr);
	auto=: ConvertToBoolean autostr;
	(autostr,file`)=: freadline file3;
	(tabsstr,file3)=: freadline file2;
	(sizestr,file2)=: freadline file1;
	(fontstr,file1)=: freadline file;
	};

ConvertToNumber	:: String -> Int;
ConvertToNumber str =  StringToInt (AfterColon str);

ConvertToString	:: String -> String;
ConvertToString str =  StripNewline (AfterColon str);

ConvertToBoolean	:: String -> Bool;
ConvertToBoolean str
	|  # aftercolon  == 0 =  False;
	=   first == 'y'  ||  first == 'Y' ;
	where {
	aftercolon=: AfterColon str;
	first     =: aftercolon !! 0;
	};

AfterColon	:: String -> String;
AfterColon str | len == 0 || colon_i >= len =  "";
	               =  str % (colon_i, dec len);
	where {
	colon_i=: FindColon 0 len str;
	len    =: # str;
	};

FindColon	:: Int Int String -> Int;
FindColon i len str
	| i >= len =  i;
	|  str !! i  == ':' =  SkipSpaces (inc i) len str;
	=  FindColon (inc i) len str;

SkipSpaces	:: Int Int String -> Int;
SkipSpaces i len str | i >= len ||  str !! i  == ' ' =  inc i;
	                     =  SkipSpaces (inc i) len str;

//
//	Write the default settings
//

SaveDefaultSettings	:: Editor -> Editor;
SaveDefaultSettings editor
	| not open =  editor`;
	=  CloseUFile (WriteDefaults defs file) editor``;
	where {
	(editor``,defs)    =: GetDefaults editor`;
	(editor`,open,file)=: OpenUFile PrefsPath FWriteText editor;
	};

WriteDefaults	:: Defaults UFILE -> UFILE;
WriteDefaults (tabs,(font,size),auto) file
	=  FWriteStrings ["Auto indent   : ", BoolToAnswer auto] (
	   FWriteStrings ["Tab stop every: ", toString tabs, " spaces"] (
	   FWriteStrings ["Font size     : ", toString size, " points"] (
	   FWriteStrings ["Font          : ", font] file)));

FWriteStrings	:: [String] UFILE -> UFILE;
FWriteStrings [str : rest] file =  FWriteStrings rest (fwrites str file);
FWriteStrings []           file =  fwritec '\n' file;

BoolToAnswer	:: Bool  -> String;
BoolToAnswer False =  "No";
BoolToAnswer true  =  "Yes";

/* Add the home directory path to the prefs file */

PrefsPath	::    String;
PrefsPath = HomePath PrefsFile;
