definition module StdOverloaded

// ****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.0
//	Copyright 1995 University of Nijmegen
// ****************************************************************************************

overload (+)  infixl 6	a	:: !a	!a	->	a				//	Add arg1 to arg2
overload (-)  infixl 6	a	:: !a	!a	->	a 				//	Subtract arg2 from arg1
overload zero 			a	:: a							//	Zero (unit element for addition)

overload (*)  infixl 7	a	:: !a	!a	->	a				//	Multiply arg1 with arg2
overload (/)  infix  7	a	:: !a	!a	->	a				//	Divide arg1 by arg2
overload one 			a	:: a							//	One (unit element for multiplication)

overload (^)  infixr 8	a	:: !a	!a 	->	a				//	arg1 to the power of arg2
overload inc 			a	:: !a 		->	a 				//	Increment with 1
overload dec  			a	:: !a 		->	a 				//	Decrement with 1
overload abs  			a	:: !a		->	a				//	Absolute value
overload sign 			a	:: !a 		->	Int				//	1 (pos value) -1 (neg value) 0 (if zero)
overload ~				a	:: !a 		->	a				//	-a1

overload (==) infix  2	a	:: !a	!a	->	Bool			//	True if arg1 is equal to arg2

overload (<)  infix  2	a	:: !a	!a	->	Bool	 		//	True if arg1 is less than arg2

overload toInt			a	:: !a		->	Int				//	Convert into Int
overload toChar			a	:: !a		->	Char			//	Convert into Char
overload toBool			a	:: !a		->	Bool			//	Convert into Bool
overload toReal			a	:: !a		->	Real			//	Convert into Real
overload toString		a	:: !a		->	String			//	Convert into String

overload fromInt		a	:: !Int		-> a				//	Convert from Int
overload fromChar		a	:: !Char	-> a				//	Convert from Char
overload fromBool		a	:: !Bool	-> a				//	Convert from Bool
overload fromReal		a	:: !Real	-> a				//	Convert from Real
overload fromString		a	:: !String	-> a				//	Convert from String

overload  #  		  	a	:: !a				-> Int		//	Number of elements in arg
overload  ##  		  	a	:: !a				-> Int		//	Upperbound of arg
overload  (%)  infixl 9	a	:: !a !(!Int,!Int)	-> a		//	Slice a part from arg1

overload (+++)infixr 0	a 	:: !a	!a			-> a		//	Append args
