system module StdInt 

// ****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.0
//	Copyright 1995 University of Nijmegen
// ****************************************************************************************

import	StdOverloaded

instance +				Int
instance -  			Int
instance zero			Int

instance *  			Int
instance /				Int
instance one			Int

instance ^				Int
instance inc			Int
instance dec			Int
instance abs			Int
instance sign			Int
instance ~				Int

instance ==				Int

instance <  			Int

instance toInt			Int
instance toChar			Int
instance toReal			Int
instance toString		Int

instance fromInt		Int
instance fromInt		Char
instance fromInt		Real
instance fromInt		String

// Additional functions for integer arithmetic: 

(mod)	infix  7	:: !Int !Int	->	Int 	//	arg1 modulo arg2
(rem)	infix  7	:: !Int !Int	->	Int 	//	remainder after integer division
gcd 				:: !Int !Int 	->	Int		//	Greatest common divider
lcm 				::  Int !Int	->	Int		//	Least common multiple

//	Test on Integers:

isEven 				:: !Int 		->	Bool	//	True if arg1 is an even number
isOdd 				:: !Int 		->	Bool	//	True if arg1 is an odd  number

//	Operators on Bits:

(bitor)	infixl  0	:: !Int !Int 	->	Int 	//	Bitwise Or of arg1 and arg2
(bitand) infixl 1	:: !Int !Int 	->	Int 	//	Bitwise And of arg1 and arg2
(bitxor) infixl 0	:: !Int !Int 	->	Int 	//	Exclusive-Or arg1 with mask arg2
(<<)	infix  7	:: !Int !Int 	->	Int 	//	Shift arg1 to the left arg2 bit places
(>>)	infix  7	:: !Int !Int 	->	Int 	//	Shift arg1 to the right arg2 bit places
bitnot				:: !Int 		->	Int 	//	One's complement of arg1
