definition module EdText;

from EdTypes import Text,TLine,Clipboard,Selection,CurLine, Block, PartSel;
from EdConstants import NewlStr;

     
EmptyText	:== [[EmptyLine]];
EmptyLine	:== [NewlStr];

    
Text_GetLine	:: Int Text -> TLine;
Text_GetLines	:: Int Int Text -> [TLine];
Text_SetLine	:: Int TLine Text -> Text;
Text_InsertLine	:: Int TLine Text -> Text;
Text_RemoveLine	:: Int Text -> Text;
Text_CutSelection	:: Selection Text -> (Clipboard,Text);
Text_CopySelection	:: Selection Text -> Clipboard;
Text_PasteClipboard	:: Clipboard Int Int Text -> Text;
Text_StringsToText	:: [String] -> Text;
Line_LineToString	:: TLine -> String;
Line_MakeLine	:: String -> TLine;
Line_SplitLine	:: Int TLine -> (TLine,TLine);
Line_GlueLine	:: TLine TLine -> TLine;
Line_GlueAfter	:: TLine TLine -> TLine;
Line_NrChars	:: TLine -> Int;
LineToBefore :: TLine TLine -> TLine;
BeforeToLine	:: TLine -> TLine;
CutFromCurLine	:: Selection CurLine -> (Clipboard,TLine,TLine);
If	:: Bool t t -> t;
