implementation module tmdialog;

import	StdClass;
from	StdFile		import Files;
from	StdInt			import dec, inc, ==;
from	StdString			import +++;
import	deltaDialog;
import	deltaEventIO;
from	deltaMenu		import EnableMenuItems, DisableMenuItems;
from	deltaWindow		import DrawInWindow;

import	showtm, tmfile;

    

::	* Tm :== (TmState, String, Int, Disk, Bool);

::	* IOTm :==  IOState Tm;
::	* DialogIOTm :==  IOState Tm;
::	* TmIOState :== (Tm, IOTm);


     
	
	HelpFile :== "TuringHelp";

	FileMenuId    :== 2;
		NewItemId   :== 21;
		OpenItemId  :== 22;
		SaveItemId	:== 23;
		SvAsItemId	:== 24;
		HelpItemId	:== 25;
		QuitItemId	:== 26;
	MachineMenuId :== 3;
		StepItemId	:== 31;
		RunItemId	:== 32;
		HaltItemId	:== 34;
		DelayItemId	:== 35;
			VerSId	:== 351;
			SlowId	:== 352;
			NormId	:== 353;
			FastId	:== 354;
			VerFId	:== 355;
	
	WindowID :== 1;
	TapeWdID :== 3;

	ACId	:== 2;
		ACCancelId	:== 21;
		ACOKId	  	:== 22;
		ACCellId	:== 23;
	ASId	:== 3;
		ASCancelId	:== 31;
		ASOKId	  	:== 32;
		ASEditId	:== 33;
	ATId	:== 4;
		ATCancelId	:== 41;
		ATOKId	  	:== 42;
		ATRemoveId	:== 43;
		ATFromId	:== 44;
		ATHeadId	:== 45;
		ATToId		:== 46;
		ATMoveId	:== 47;

		SBCSaveId	:== 51;
		SBCDontId	:== 52;
		SBCCnclId	:== 53;

	TimerID	:== 1;

    


/*	The dialog to alter the contents of a tape cell.
*/

AlterCell	:: Int Tm IOTm -> TmIOState;
AlterCell pos tm=:(((ts,tp,st),tn,cm),nm,dl,dk,sd) io
		=  OpenModalDialog dialog tm` io`;
		   where {
		   dialog=:    CommandDialog ACId "Change Tape Cell" [] ACOKId
					    [stext, etext, cancel, ok];
		   stext=:     StaticText 1 Center "Write:";
		   etext=:     EditText ACCellId (RightTo 1) (MM 15.0) 1 "";
		   cancel=:    DialogButton ACCancelId Center  "Cancel" Able (ACCancel pos cell);
		   ok=:	      DialogButton ACOKId (RightTo ACCancelId) "OK" Able (ACOK pos);
		   (tm`,io`)=: DoHiliteCell pos cell tm io;
		   cell=:      CellContents pos tp;
		   };

ACOK	:: Int DialogInfo Tm IOTm -> TmIOState;
ACOK pos dialog (((ts,tp,st),tn,cm),nm,dl,dk,sd) io
		 =  ((((ts, tape, st), tn, cm), nm, dl, dk, sd), io`);
		    where {
		    tape=: ChangeCellContents pos tp cell;
		    io`=:  DrawInWindow TapeWdID [DrawTapeCell pos cell] (CloseActiveDialog io);
		    cell=: FirstChar (GetEditText ACCellId dialog);
		    };
		    
ACCancel	:: Int Char DialogInfo Tm IOTm -> TmIOState;
ACCancel pos cell dialog tm io
		= 	(tm, DrawInWindow TapeWdID [DrawTapeCell pos cell] (CloseActiveDialog io));

DoHiliteCell	:: Int Char Tm IOTm -> TmIOState;
DoHiliteCell pos cell tm io
		=  (tm, DrawInWindow TapeWdID [HiliteCell pos cell] io);


/*	The dialog to alter a transition.
*/

AlterTransition	:: Int Tm IOTm -> TmIOState;
AlterTransition tnr tm=:(((ts,tp,st),tn,cm),nm,dl,dk,sd) io
		=  OpenModalDialog dialog tm` io`;
		   where {
		   dialog=: CommandDialog ATId "Change Transition" [] ATOKId
					 [sfrom, efrom, shead, ehead, sto, eto, smove, emove, cancel, remove, ok];
		   sfrom=:  DynamicText 1 Left (MM 20.0) "From:";
		   efrom=:  EditText ATFromId (RightTo 1) (MM 25.0) 1 frst;
		   shead=:  DynamicText 3 Left (MM 20.0) "With:";
		   ehead=:  EditText ATHeadId (RightTo 3) (MM 20.0) 1 (MyCTOS head);
		   sto=:	   DynamicText 5 (XOffset ATFromId (MM 10.0)) (MM 20.0) "To:";
		   eto=:	   EditText ATToId (RightTo 5) (MM 25.0) 1 tost;
		   smove=:  DynamicText 7 (Below 5) (MM 20.0) "Action:";
		   emove=:  EditText ATMoveId (RightTo 7) (MM 20.0) 1 (MyCTOS move);
		   cancel=: DialogButton ATCancelId Center "Cancel" Able (ATCancel tnr trans);
		   remove=: DialogButton ATRemoveId (RightTo ATCancelId) "Remove" Able (ATRemove tnr);
		   ok=:	   DialogButton ATOKId (RightTo ATRemoveId) "OK" Able (ATOK tnr);
		   (tm`,io`)=: DoHiliteTransition tnr trans tm io;
		   trans=:     (from_new,to);
		   (from_new,to)=: GetTransition tnr ts;
		   (frst,head)=: from_new;
		   (tost,move)=: to;
		   };

MyCTOS	:: Char -> String;
MyCTOS ' '  =  "";
MyCTOS char =  toString char;

ATOK	:: Int DialogInfo Tm IOTm -> TmIOState;
ATOK tnr dialog (((ts,tp,st),tn,cm),nm,dl,dk,sd) io
		 =  ((((trs, tp, st), tn, cm), nm, dl, dk, False), io``);
		    where {
		    trs=:   ChangeTransition tnr trans ts;
		    trans=: ((from_new, head), (to, move));
		    io`=:   DrawInWindow WindowID [ShowTrans tnr trans] (CloseActiveDialog io);
		    io``=:  EnableMenuItems [SaveItemId] io`;
		    from_new=:  FourCharString (GetEditText ATFromId dialog);
		    head=:  FirstChar (GetEditText ATHeadId dialog);
		    to=:    FourCharString (GetEditText ATToId dialog);
		    move=:  FirstChar (GetEditText ATMoveId dialog);
		    };
		    
ATCancel	:: Int Trans DialogInfo Tm IOTm -> TmIOState;
ATCancel tnr trans=:((f,h),(t,m)) dialog tm io
		| f == "" =  (tm, DrawInWindow WindowID [EraseTrans tnr] (CloseActiveDialog io));
		=  (tm, DrawInWindow WindowID [ShowTrans tnr trans] (CloseActiveDialog io));

ATRemove	:: Int DialogInfo Tm IOTm -> TmIOState;
ATRemove tnr dialog (((ts,tp,st),tn,cm),nm,dl,dk,sd) io
		=  ReDraw (((trs, tp, st), 0, cm), nm, dl, dk, False) io`;
		   where {
		   trs=: RemoveTransition tnr ts;
		   io`=: EnableMenuItems [SaveItemId] (CloseActiveDialog io);
		   };

DoHiliteTransition	:: Int Trans Tm IOTm -> TmIOState;
DoHiliteTransition tnr trans tm io
		=  (tm, ChangeIOState [DrawInWindow WindowID [HiliteTransition tnr trans],
							   DrawInWindow TapeWdID [EraseError]] io);


/*	The dialog to alter the state of the T.M.
*/

AlterState	:: Tm IOTm -> TmIOState;
AlterState tm=:(((ts,tp,state),tn,cm),nm,dl,dk,sd) io
		=  OpenModalDialog dialog tm` io`;
		   where {
		   dialog=: CommandDialog ASId "Change State" [] ASOKId
					 [stext, etext, cancel, ok];
		   stext=:  StaticText 1 Left "State:";
		   etext=:  EditText ASEditId (RightTo 1) (MM 25.0) 1 "";
		   cancel=: DialogButton ASCancelId Center "Cancel" Able (ASCancel state);
		   ok=:	   DialogButton ASOKId (RightTo ASCancelId) "OK" Able ASOK;
		   (tm`,io`)=: DoHiliteState state tm io;
		   };

ASOK	:: DialogInfo Tm IOTm -> TmIOState;
ASOK dialog (((ts,tp,st),tn,cm),nm,dl,dk,sd) io
	= 	((((ts, tp, state), tn, cm), nm, dl, dk, sd), io`);
		where {
		io`=: ChangeIOState [DrawInWindow WindowID [ShowNextState state],
		                    ASChangeMenus state, CloseActiveDialog] io;
		state=: FourCharString (GetEditText ASEditId dialog);
		};

ASChangeMenus	:: String IOTm -> IOTm;
ASChangeMenus state iostate
		| state == "halt" =  DisableMenuItems [StepItemId, HaltItemId] iostate;
		=  EnableMenuItems  [StepItemId, HaltItemId] iostate;

ASCancel	:: String DialogInfo Tm IOTm -> TmIOState;
ASCancel state dialog tm io
		= 	(tm, DrawInWindow WindowID [ShowNextState state] (CloseActiveDialog io));

DoHiliteState	:: String Tm IOTm -> TmIOState;
DoHiliteState state tm io
		=  (tm, DrawInWindow WindowID [HiliteState state] io`);
		   where {
		   io`=: DrawInWindow TapeWdID [EraseError] io;
		   };


/*	The function to redraw the entire machine when an update-event takes place.
*/

ReDraw	:: Tm IOTm -> TmIOState;
ReDraw tm=:(((trs, tape, state), cn, cm), name, dl, dk, sd) io
	= 	(tm, ChangeIOState [DrawInWindow TapeWdID [ShowTape tape],
							DrawInWindow WindowID [ShowTransitions trs state]] io);


/*	General alert dialog.
*/

Alert	:: String String IOTm -> IOTm;
Alert mes1 mes2 io =  io`;
		where {
		(id,io`)=: OpenNotice (Notice [mes1,mes2] (NoticeButton 1 "OK") []) io;
		};

/*	Save before close dialog.
*/

SaveBeforeClose	:: String Tm IOTm -> (Bool,Tm,IOTm);
SaveBeforeClose mes tm=:(tr,nm,dl,dk,sd) io
	| butid == SBCSaveId = 	SvBfClSave tm io`;
	| butid == SBCDontId = 	(True ,tm,io`);
	= 	(False,tm,io`);
		where {
		(butid,io`)=: OpenNotice (Notice [line1,line2] yes [no,cancel]) io;
		line1	=: "Save changes to \"" +++   RemovePath nm  +++ "\"" ;
		line2	=: "before " +++  mes +++ "?" ;
		yes		=: NoticeButton SBCSaveId "Yes";
		no		=: NoticeButton SBCDontId "No";
		cancel	=: NoticeButton SBCCnclId "Cancel";
		};

SvBfClSave	:: Tm IOTm -> (Bool,Tm,IOTm);
SvBfClSave tm=:((turing,trn,com),name,del,disk,saved) io
		=  (True, ((turing,trn,com),name,del,newd,True), io`);
		   where {
		   (success, newd)=: WriteTuringToFile turing name disk;
		   io`=: DisableMenuItems [SaveItemId] io;
		   };
