implementation module EdSpecialKeys;

/*	Functions that deal with some of the special keys */

import	StdClass;
import StdInt, StdString, StdBool;
import deltaEventIO, deltaWindow, deltaMenu;

import EdProgramState, EdSupport, EdDraw;

     
	None :== 0;
	Optn :== 1;
	Comd :== 2;

    

/*	Remove a character when backspace is typed */

TypeBackSpace	:: CurLine EditWindow Editor IO -> EdIO;

TypeBackSpace ([],after,lnr,cnr) front editor io
	| not notfirst =  (editor,io);
	| top <= cy  =  (editor`, io`);
	= ChangeActiveScrollBar (ChangeVThumb (top - hght)) editor` io`;
/*	RWS
	| notfirst && top <= cy  =  (editor`, io`);
	| notfirst =  ChangeActiveScrollBar (ChangeVThumb (top - hght)) editor` io`;
	=  (editor,io);
*/
	where {
	editor`=: ChangeFrontWindow [ EW_SetCurLine (before,after,linenr,charnr),
			                       EW_SetCursorPos newpos,
			                       EW_SetSaved False,
			                       EW_SetText text`,
			                       EW_SetNrLines nrlines ] editor1;
	io`=: DrawInActiveWindow [ DrawRestCurLine cx basey ptabw right after,
	                          Erase_and_DrawLines (basey + hght) hght ofs ptabw right lines,
	                          DrawCursor newpos cht ld ] io5;
	(visrect,io5)	=: ActiveWindowGetFrame io4;
	(editor1,io4)	=: AdjustWindowSize nrlines front editor io3;
	io3				=: DrawInActiveWindow [RemoveCursor oldpos cht ld] io2;
	io2				=: NotSavedAnymore (EW_Saved front) io;
	cx					=: CalcCursorX LinesLeft ptabw line rfont;
	notfirst			=: lnr > 0;
	before			=: LineToBefore line [];
	line				=: Text_GetLine linenr text;
	linenr			=: dec lnr;
	text				=: EW_GetText front;
	len				=: dec charnr;
	charnr			=: Line_NrChars line;
	newpos			=: (True,cx,cy,cx);
	(rtw,ptabw)		=: EW_GetTabWidth front;
	cy					=: ocy - hght;
	oldpos			=: EW_GetCursorPos front;
	(v,ocx,ocy,ux)	=: oldpos;
	cht				=: at_new + dt;
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	text`				=: Text_RemoveLine lnr text;
	nrlines			=: dec (EW_GetNrLines front);
	basey				=: cy + ofs;
	ofs				=: at_new + ld;
	lines				=: Text_GetLines first number text`;
	first				=: Between 0 (dec nrlines) lnr;
	number			=: If (lnr >= nrlines) 0 (Between 0 (nrlines - first) nr);
	nr					=: inc ( (bot - PictureTop) / hght  - lnr);
	(right,bot)		=: botright;
	(left,top)		=: topl;
	(topl,botright)=: visrect;
	};

TypeBackSpace (before=:[str:rest],after,linenr,cnr) front editor io
	| str == TabStr =  (editort,iot);
	=  (editor`,io`); 
	where {
	editor`=: ChangeFrontWindow [ EW_SetCurLine (newbef,after,linenr,dec cnr),
			                       EW_SetCursorPos newpos,
			                       EW_SetSaved False ] editor;
	io`=: DrawInActiveWindow [RemoveCursor oldpos cht ld,
		                      DrawBackspCurLine cx` width cy ht ptabw right after,
		                      DrawCursor newpos cht ld] io3;
	io3=: NotSavedAnymore (EW_Saved front) io2;
	(visrect,io2)	=: ActiveWindowGetFrame io;
	width				=: FontCharWidth char rfont;
	(char,newbef)	=: RemoveCharBefore before;
	newpos			=: (True,cx`,cy,cx`);
	cx`				=: cx - width;
	oldpos			=: EW_GetCursorPos front;
	(b,cx,cy,ux)	=: oldpos;
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	(at_new,dt,ld,ht)	=: EW_GetFontMetrics front;
	(rtw,ptabw)		=: EW_GetTabWidth front;
	(right,bot)		=: botright;
	(topl,botright)=: visrect;
	editort=: ChangeFrontWindow [ EW_SetCurLine (rest,after,linenr,dec cnr),
			                       EW_SetCursorPos tabpos,
			                       EW_SetSaved False ] editor;
	iot=: DrawInActiveWindow [RemoveCursor oldpos cht ld,
	                         DrawBackspCurLine cxtab (cx - cxtab) cy ht ptabw right after,
		                      DrawCursor tabpos cht ld] iou;
	iou=: NotSavedAnymore (EW_Saved front) io2;
	cxtab				=: CalcCursorX LinesLeft ptabw (Reverse rest) rfont;
	tabpos			=: (True,cxtab,cy,cxtab);
	cht=:(at_new + dt);
		};

/*	BackSpace a word when Option-backspace was typed */

TypeBackSpaceWord	:: CurLine EditWindow Editor IO -> EdIO;
TypeBackSpaceWord cline=:([],after,lnr,cnr) front editor io
	=  TypeBackSpace cline front editor io;
TypeBackSpaceWord (before,after,linenr,cnr) front editor io =  (editor`,io`); 
	where {
	editor`=: ChangeFrontWindow [ EW_SetCurLine (newbef,after,linenr,charnr),
			                       EW_SetCursorPos newpos,
			                       EW_SetSaved False ] editor;
	io`=: DrawInActiveWindow [RemoveCursor oldpos cht ld,
		                      DrawBackspCurLine cx` (cx - cx`) cy ht ptabw right after,
		                      DrawCursor newpos cht ld] io3;
	io3=: NotSavedAnymore (EW_Saved front) io2;
	(visrect,io2)	=: ActiveWindowGetFrame io;
	(word,newbef)	=: RemoveWordBefore before;
	cx`				=: CalcCursorX LinesLeft ptabw (Reverse newbef) rfont;
	charnr			=: cnr -  # word ;
	newpos			=: (True,cx`,cy,cx`);
	oldpos			=: EW_GetCursorPos front;
	(b,cx,cy,ux)	=: oldpos;
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	(at_new,dt,ld,ht)	=: EW_GetFontMetrics front;
	(rtw,ptabw)		=: EW_GetTabWidth front;
	(right,bot)		=: botright;
	(topl,botright)=: visrect;
	cht=:(at_new + dt);
		};


/*	Direction determines which move-function should be called
*/

Direction	:: Int Char CurLine EditWindow Editor IO -> EdIO;
Direction mod_new LeftKey cline front editor io
	| mod_new == None =  GoLeft cline front editor io;
	| mod_new == Optn =  WordLeft cline front editor io;
	=  LineLeft cline front editor io;
Direction mod_new RightKey cline front editor io
	| mod_new == None =  GoRight cline front editor io;
	| mod_new == Optn =  WordRight cline front editor io;
	=  LineRight cline front editor io;
Direction mod_new UpKey cline front editor io
	| mod_new == Comd =  WindowUp editor io;
	=  Up front editor io;
Direction mod_new DownKey cline front editor io
	| mod_new == Comd =  WindowDown editor io;
	=  Down front editor io;

//
// The move functions.
//

GoLeft	:: CurLine EditWindow Editor IO -> EdIO;
GoLeft ([],after,lnr,cnr) front editor io
	| not notfirst =  (editor,io);
	| top <= cy =  (editor`, io`);
	= ChangeActiveScrollBar (ChangeVThumb (top - hght)) editor` io`;
/* RWS
	| notfirst && top <= cy =  (editor`, io`);
	| notfirst =  ChangeActiveScrollBar (ChangeVThumb (top - hght)) editor` io`;
	=  (editor,io);
*/
	where {
	editor`=: ChangeFrontWindow [ EW_ResetCurLine,
			                       EW_SetCurLine (before,[NewlStr],linenr,charnr),
			                       EW_SetCursorPos (False,cx,cy,cx) ] editor;
	(visrect,io`)	=: ActiveWindowGetFrame io;
	cx					=: CalcCursorX LinesLeft ptabw line rfont;
	notfirst			=: lnr > 0;
	before			=: LineToBefore line [];
	line				=: Text_GetLine linenr text;
	linenr			=: dec lnr;
	text				=: EW_GetText front;
	charnr			=: Line_NrChars line;
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	(rtw,ptabw)		=: EW_GetTabWidth front;
	cy					=: ocy - hght;
	(v,ocx,ocy,ux)	=: EW_GetCursorPos front;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	(left,top)		=: topleft;
	(topleft,botr)	=: visrect;
	};

GoLeft (bef=:[str:rest],aft,linenr,cnr) front editor io
	| str == TabStr =  (editort,io);
	=  (editor`,io); 
	where {
	editor`=: ChangeFrontWindow [ EW_SetCurLine (before,after,linenr,dec cnr),
			                       EW_SetCursorPos (True,cx`,cy,cx`) ] editor;
	(char,before)	=: RemoveCharBefore bef;
	after				=: AddCharAfter char aft;
	width				=: FontCharWidth char rfont;
	cx`				=: cx - width;
	(b,cx,cy,ux)	=: EW_GetCursorPos front;
	editort=: ChangeFrontWindow [ EW_SetCurLine (rest,[TabStr:aft],linenr,dec cnr),
			                       EW_SetCursorPos (False,cxtab,cy,cxtab) ] editor;
	cxtab				=: CalcCursorX LinesLeft ptabw (Reverse rest) rfont;
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	(rtw,ptabw)		=: EW_GetTabWidth front;
	};


GoRight	:: CurLine EditWindow Editor IO -> EdIO;
GoRight (bef,[NewlStr],lnr,cnr) front editor io
	| not notlast =  (editor,io);
	| cbot > bot =  ChangeActiveScrollBar (ChangeVThumb vtmb) editor` io`;
	=  (editor`,io`);
/* RWS
	| notlast && cbot > bot =  ChangeActiveScrollBar (ChangeVThumb vtmb) editor` io`;
	| notlast =  (editor`,io`);
	=  (editor,io);
*/
	where {
	editor`=: ChangeFrontWindow [ EW_ResetCurLine,
				                    EW_SetCurLine ([],after,linenr,0),
			                       EW_SetCursorPos (False,0,cy,0) ] editor;
	(visrect,io`)		=: ActiveWindowGetFrame io;
	notlast				=: linenr <  EW_GetNrLines front ;
	after					=: Text_GetLine linenr (EW_GetText front);
	cy						=: oldcy + hght;
	(v,oldcx,oldcy,ux)=: EW_GetCursorPos front;
	(at_new,dt,ld,hght)	=: EW_GetFontMetrics front;
	cbot					=: cy + (at_new + dt);
	vtmb					=: top +  hght *  inc ((cbot - bot) / hght)  ;
	linenr				=: inc lnr;
	(left,top)			=: topleft;
	(right,bot)			=: botright;
	(topleft,botright)=: visrect;
	};

GoRight (bef,aft=:[str:rest],linenr,cnr) front editor io
	| str == TabStr =  (editort,io );
	=  (editor`,io); 
	where {
	editor`=: ChangeFrontWindow [ EW_SetCurLine (before,after,linenr,inc cnr),
			                       EW_SetCursorPos (False,cx`,cy,cx`) ] editor;
	(char,after)	=: RemoveCharAfter aft;
	before			=: AddCharBefore char bef;
	cx`				=: cx + width;
	width				=: FontCharWidth char rfont;
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	(b,cx,cy,ux)	=: EW_GetCursorPos front;
	editort=: ChangeFrontWindow [ EW_SetCurLine ([TabStr:bef],rest,linenr,inc cnr),
			                       EW_SetCursorPos tabpos ] editor;
	(rtw,ptabw)		=: EW_GetTabWidth front;
	tabpos			=: (True,tx,cy,tx);
	tx=:ptabw *  inc (cx / ptabw) ;
		};


Up	:: EditWindow Editor IO -> EdIO;
Up front editor io
	| not notfirst =  (editor,io);
	| top <= cy =  (editor`, io`);
	=  ChangeActiveScrollBar (ChangeVThumb (top - hght)) editor` io`;
/* RWS
	| notfirst && top <= cy =  (editor`, io`);
	| notfirst =  ChangeActiveScrollBar (ChangeVThumb (top - hght)) editor` io`;
	=  (editor,io);
*/
	where {
	editor`=: ChangeFrontWindow [ EW_ResetCurLine,
	                             EW_SetCurLine (before,after,linenr,charnr),
			                       EW_SetCursorPos (False,cx,cy,ux) ] editor;
	(visrect,io`)	=: ActiveWindowGetFrame io;
	(cx,charnr)		=: CalcCharNumber ux ptabw line rfont;
	notfirst			=: lnr > 0;
	(bf,af,lnr,cnr)=: EW_GetCurLine front;
	cy					=: ocy - hght;
	(v,ocx,ocy,ux)	=: EW_GetCursorPos front;
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	(before,after)	=: Line_SplitLine charnr line;
	line				=: Text_GetLine linenr (EW_GetText front);
	linenr			=: dec lnr;
	(rtw,ptabw)		=: EW_GetTabWidth front;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	(left,top)		=: topleft;
	(topleft,botr)	=: visrect;
	};


Down	:: EditWindow Editor IO -> EdIO;
Down front editor io
	| not notlast =  (editor,io);
	| cbot > bot =  ChangeActiveScrollBar (ChangeVThumb vtmb) editor` io`;
	=  (editor`,io`);
/* RWS
	| notlast && cbot > bot =  ChangeActiveScrollBar (ChangeVThumb vtmb) editor` io`;
	| notlast =  (editor`,io`);
	=  (editor,io);
*/
	where {
	editor`=: ChangeFrontWindow [ EW_ResetCurLine,
	                             EW_SetCurLine (before,after,linenr,charnr),
			                       EW_SetCursorPos (False,cx,cy,ux) ] editor;
	(visrect,io`)	=: ActiveWindowGetFrame io;
	(cx,charnr)		=: CalcCharNumber ux ptabw line rfont;
	notlast			=: linenr <  EW_GetNrLines front ;
	(bf,af,lnr,cnr)=: EW_GetCurLine front;
	cy					=: ocy + hght;
	(v,ocx,ocy,ux)	=: EW_GetCursorPos front;
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	(before,after)	=: Line_SplitLine charnr line;
	line				=: Text_GetLine linenr (EW_GetText front);
	linenr			=: inc lnr;
	(rtw,ptabw)		=: EW_GetTabWidth front;
	cbot				=: cy + (at_new + dt);
	vtmb				=: top +  hght *  inc ((cbot - bot) / hght)  ;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	(right,bot)		=: botr;
	(left,top)		=: topleft;
	(topleft,botr)	=: visrect;
	};


WordLeft	:: CurLine EditWindow Editor IO -> EdIO;
WordLeft cline=:([],after,lnr,cnr) front editor io
	=  GoLeft cline front editor io;
WordLeft (bef,aft,linenr,cnr) front editor io
	=  (editor`,io); 
	where {
	editor`=: ChangeFrontWindow [ EW_SetCurLine (before,after,linenr,charnr),
			                       EW_SetCursorPos (False,cx`,cy,cx`) ] editor;
	cx`				=: CalcCursorX LinesLeft ptabw (Reverse before) rfont;
	(word,before)	=: RemoveWordBefore bef;
	after				=: AddWordAfter word aft;
	charnr			=: cnr -  # word ;
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	(b,cx,cy,ux)	=: EW_GetCursorPos front;
	(rtw,ptabw)		=: EW_GetTabWidth front;
	};


WordRight	:: CurLine EditWindow Editor IO -> EdIO;
WordRight cline=:(bef,[NewlStr],lnr,cnr) front editor io
	=  GoRight cline front editor io;
WordRight (bef,aft,linenr,cnr) front editor io
	=  (editor`,io); 
	where {
	editor`=: ChangeFrontWindow [ EW_SetCurLine (before,after,linenr,charnr),
			                       EW_SetCursorPos (False,cx`,cy,cx`) ] editor;
	cx`				=: CalcCursorX LinesLeft ptabw (Reverse before) rfont;
	(word,after)	=: RemoveWordAfter aft;
	before			=: AddWordBefore word bef;
	charnr			=: cnr +  # word ;
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	(b,cx,cy,ux)	=: EW_GetCursorPos front;
	(rtw,ptabw)		=: EW_GetTabWidth front;
	};


LineLeft	:: CurLine EditWindow Editor IO -> EdIO;
LineLeft cline=:([],after,lnr,cnr) front editor io
	=  GoLeft cline front editor io;
LineLeft (bef,aft,linenr,cnr) front editor io
	=  (editor`,io); 
	where {
	editor`=: ChangeFrontWindow [ EW_SetCurLine ([],after,linenr,0),
			                       EW_SetCursorPos (False,cx`,cy,cx`) ] editor;
	cx`				=: LinesLeft;
	after				=: Line_GlueLine bef aft;
	(b,cx,cy,ux)	=: EW_GetCursorPos front;
	};


LineRight	:: CurLine EditWindow Editor IO -> EdIO;
LineRight cline=:(bef,[NewlStr],lnr,cnr) front editor io
	=  GoRight cline front editor io;
LineRight (bef,aft,linenr,cnr) front editor io
	=  (editor`,io); 
	where {
	editor`=: ChangeFrontWindow [ EW_SetCurLine (before,[NewlStr],linenr,charnr),
			                       EW_SetCursorPos (False,cx`,cy,cx`) ] editor;
	cx`				=: CalcCursorX LinesLeft ptabw (Reverse before) rfont;
	before			=: Line_GlueAfter bef aft;
	charnr			=: Line_NrChars before;
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	(b,cx,cy,ux)	=: EW_GetCursorPos front;
	(rtw,ptabw)		=: EW_GetTabWidth front;
	};


WindowUp	:: Editor IO -> EdIO;
WindowUp editor io
	| cx == ocx && cy == ocy =  (editor2, io`);
	=  (editor`, io`);
	where {
	editor`=: ChangeFrontWindow [ EW_SetCurLine ([],after,linenr,0),
			                       EW_SetCursorPos (False,cx,cy,cx) ] editor2;
	(visrect,io`)	=: ActiveWindowGetFrame io1;
	(editor2,io1)	=: EvtScrollWindowUp front editor1 io;
	(editor1,front)=: ResetCurLine_and_GetFrontWindow editor;
	after				=: Text_GetLine linenr (EW_GetText front);
	linenr			=: Between 0 (dec nrlines) ((top - PictureTop) / hght);
	cx					=: LinesLeft;
	cy					=: PictureTop +  hght * linenr ;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	(v,ocx,ocy,oux)=: EW_GetCursorPos front;
	nrlines			=: EW_GetNrLines front;
	(left,top)		=: topl;
	(topl,botr)		=: visrect;
	};

EvtScrollWindowUp	:: EditWindow Editor IO -> EdIO;
EvtScrollWindowUp front editor io
	| top == PictureTop || cx > LinesLeft || cy > top =  (editor,io`);
	=  ChangeActiveScrollBar (ChangeVThumb vtmb) editor io`;
	where {
	(visrect,io`)	=: ActiveWindowGetFrame io;
	vtmb				=: top - (bot - top);
	(v,cx,cy,ux)	=: EW_GetCursorPos front;
	(left,top)		=: topl;
	(right,bot)		=: botr;
	(topl,botr)		=: visrect;
	};


WindowDown	:: Editor IO -> EdIO;
WindowDown editor io
	| cx == ocx && cy == ocy =  (editor2, io`);
	=  (editor`, io`);
	where {
	editor`=: ChangeFrontWindow [ EW_SetCurLine ([],after,linenr,0),
			                       EW_SetCursorPos (False,cx,cy,cx) ] editor2;
	(visrect,io`)	=: ActiveWindowGetFrame io1;
	(editor2,io1)	=: EvtScrollWindowDown front editor1 io;
	(editor1,front)=: ResetCurLine_and_GetFrontWindow editor;
	after				=: Text_GetLine linenr (EW_GetText front);
	linenr			=: Between 0 (dec nrlines) (( bot - (at_new + dt)  - PictureTop) / hght);
	cx					=: LinesLeft;
	cy					=: PictureTop +  hght * linenr ;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	nrlines			=: EW_GetNrLines front;
	(v,ocx,ocy,oux)=: EW_GetCursorPos front;
	(right,bot)		=: botr;
	(topl,botr)		=: visrect;
	};

EvtScrollWindowDown	:: EditWindow Editor IO -> EdIO;
EvtScrollWindowDown front editor io
	| cx > LinesLeft ||  cy + hght  <= botcur =  (editor,io`);
	=  ChangeActiveScrollBar (ChangeVThumb botcur) editor io`;
	where {
	(visrect,io`)	=: ActiveWindowGetFrame io;
	(v,cx,cy,ux)	=: EW_GetCursorPos front;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	botcur			=: bot - (at_new + dt);
	(left,top)		=: topl;
	(right,bot)		=: botr;
	(topl,botr)		=: visrect;
	};
