implementation module EdProgramState;

/*	Access functions on the programstate */

import	StdClass;
import StdInt, StdString, StdChar, StdBool;
from StdBool import not, &&;
from StdMisc import abort;
from StdFile import Files;
import deltaPicture, deltaFileSelect, deltaEventIO;

import EdTypes, EdConstants, EdText, EdTextFind;

    

// The IOState

::	* EdIO		:== (Editor, IO);
::	* IO		:==  IOState Editor;

// The programstate

::	* Editor	:== (Disk, Defaults, Clipboard, FindInfo, EditWdIds, EditWindows);


     

	InitClipboard	:== [];
	InitFindInfo	:== ("","",DefIgnoreCase,DefBackwards,DefWrapAround,DefMatchWords);
	InitWdIds		:== ([],FirstEditWdID);
	InitEditWds		:== [];

SelectedCurLine linenr :== ([],[],linenr,0);

	ZeroCursor		:== (False,LinesLeft,PictureTop,LinesLeft);
	EmptyCurLine	:== ([],[],0,0);
	EmptyPathname	:== "";
	EmptySelection	:== ((0,0,0,0),(0,0,0,0));
	EmptyUndo		:== (EmptyRemoved,EmptyAdded);
	EmptyRemoved	:== (False,[],0,0);
	EmptyAdded		:== (0,0,0,0);
	IsSaved			:== True;

    

//	The initial programstate.

InitEditor	:: Files -> Editor;
InitEditor files =  (files,defs,InitClipboard,InitFindInfo,InitWdIds,InitEditWds);
	where {
	defs				=: (DefTabWidth,(ft,sz),DefAutoIndent);
	(ft,st,sz)		=: DefaultFont;
	};

//	Return a fresh EditWindow.

NewEditWindow	:: Defaults Text Pathname NrLines -> EditWindow;
NewEditWindow defaults text pathname nrlines
	=  (text, ZeroCursor, EmptyCurLine, pathname, EmptySelection, EmptyUndo,
		 tabw, font, metrics, nrlines, IsSaved, autoi);
	where {
	(tabw,font,metrics,autoi)=: GetDefaultValues defaults;
	};

GetDefaultValues	:: Defaults -> (TabWidth,WindowFont,FontMetr,Bool);
GetDefaultValues (tabs,(font,size),autoi)
	=  ((tabs,tabw),(font,size,rfont),(at_new,dt,ld,ht),autoi);
	where {
	tabw				=: tabs *  FontCharWidth ' ' rfont ;
	(b,rfont)		=: SelectFont font style size;
	(ft,style,sz)	=: DefaultFont;
	ht					=: at_new + (dt + ld);
	(at_new,dt,mw,ld)	=: FontMetrics rfont;
	};

//	Operations on the Disk (FILES)

CloseDisk	:: Editor * World -> * World;
CloseDisk (disk,ds,cb,fi,is,ws) world =  closefiles disk world;

OpenInputFileSelector	:: Editor IO -> (Bool, String, Editor, IO);
OpenInputFileSelector (disk,ds,cb,fi,is,ws) io
	=  (success, fname, (disk`,ds,cb,fi,is,ws), io`);
	where {
	(success,fname,disk`,io`)=: SelectInputFile disk io;
	};

OpenOutputFileSelector	:: String Editor IO -> (Bool, String, Editor, IO);
OpenOutputFileSelector fname (disk,ds,cb,fi,is,ws) io
	=  (success, fname`, (disk`,ds,cb,fi,is,ws), io`);
	where {
	(success,fname`,disk`,io`)=: SelectOutputFile "" fname disk io;
	};

OpenUFile	:: String Int Editor -> (Editor, Bool, UFILE);
OpenUFile fname mode (disk,ds,cb,fi,is,ws) =  ((disk`,ds,cb,fi,is,ws), success, file);
	where {
	(success,file,disk`)=: fopen fname mode disk;
	};

CloseUFile	:: UFILE Editor -> Editor;
CloseUFile file (disk,ds,cb,fi,is,ws) =  let! {
		strict1;
		} in
		(disk`,ds,cb,fi,is,ws);
	where {
	(success,disk`)=: strict1;
	strict1=fclose file disk;
		};

//	Default values operations

GetDefaults	:: Editor -> (Editor, Defaults);
GetDefaults ed=:(dk,defaults,cb,fi,is,ws) =  (ed,defaults);

SetDefaults	:: Defaults Editor -> Editor;
SetDefaults defaults (dk,oldds,cb,fi,is,ws) =  (dk,defaults,cb,fi,is,ws);

//	Clipboard operations

GetClipboard	:: Editor -> (Editor, Clipboard);
GetClipboard ed=:(dk,ds,clipboard,fi,is,ws) =  (ed,clipboard);

SetClipboard	:: Clipboard Editor -> Editor;
SetClipboard clipboard (dk,ds,oldclip,fi,is,ws) =  (dk,ds,clipboard,fi,is,ws);


//	FindInfo operations

GetFindInfo	:: Editor -> (Editor, FindInfo);
GetFindInfo ed=:(dk,ds,cb,findinfo,is,ws) =  (ed,findinfo);

SetFindInfo	:: FindInfo Editor -> Editor;
SetFindInfo findinfo (dk,ds,cb,oldfi,is,ws) =  (dk,ds,cb,findinfo,is,ws);

FI_GetFind	:: FindInfo -> String;
FI_GetFind (find,rp,ic,bw,wa,mw) =  find;

FI_SetFind	:: String FindInfo -> FindInfo;
FI_SetFind find (oldfd,rp,ic,bw,wa,mw) =  (find,rp,ic,bw,wa,mw);

FI_GetReplace	:: FindInfo -> String;
FI_GetReplace (fd,replace,ic,bw,wa,mw) =  replace;

FI_SetReplace	:: String FindInfo -> FindInfo;
FI_SetReplace replace (fd,oldrp,ic,bw,wa,mw) =  (fd,replace,ic,bw,wa,mw);

FI_GetOptions	:: FindInfo -> (Bool,Bool,Bool,Bool);
FI_GetOptions (fd,rp,ic,bw,wa,mw) =  (ic,bw,wa,mw);
	//	(ignore case, backwards, wrap around, match words)

FI_SetOptions	:: Bool Bool Bool Bool FindInfo -> FindInfo;
FI_SetOptions ic bw wa mw (fd,rp,oi,ob,ow,om) =  (fd,rp,ic,bw,wa,mw);


//	Window id operations

GetNewWdId	:: Editor -> (Editor, EditWdId);
GetNewWdId (dk,ds,cb,fi,([],curid),ws)
	= 	((dk,ds,cb,fi,([],inc curid),ws), inc curid);
GetNewWdId (dk,ds,cb,fi,([wdid:ids],curid),ws)
	= 	((dk,ds,cb,fi,(ids,curid),ws), wdid);

GetUsedWdIds	:: Editor -> (Editor, [EditWdId]);
GetUsedWdIds editor=:(dk,ds,cb,fi,is,windows) =  (editor, GetWindowIds windows);
	
GetWindowIds	:: EditWindows -> [EditWdId];
GetWindowIds [] =  [];
GetWindowIds [(id,wd):wds] =  [id : GetWindowIds wds];

SetUsedWdId	:: EditWdId Editor -> Editor;
SetUsedWdId wdid (dk,ds,cb,fi,(ids,curid),ws)
	= 	(dk,ds,cb,fi,([wdid:ids],curid),ws);

//	EditWindow operations

ChangeFrontWindow	:: [EditWindow -> EditWindow] Editor -> Editor; 
ChangeFrontWindow changes editor =  SetFrontWindow newwindow editor`;
	where {
	newwindow            =: ApplyFunctions changes frontwindow;
	(editor`,frontwindow)=: GetFrontWindow editor;
	};
	
GetFrontWindow	:: Editor -> (Editor, EditWindow);
GetFrontWindow editor=:(dk,ds,cb,fi,is,windows=:[(id,active):rest])
	= 	(editor, active);
GetFrontWindow (dk,ds,cb,fi,is,[])
	= 	abort "GetFrontWindow: There are no windows";

ResetCurLine_and_GetFrontWindow	:: Editor -> (Editor,EditWindow);
ResetCurLine_and_GetFrontWindow editor =  (editor`,front`);
	where {
	editor`			=: SetFrontWindow front` editor1;
	front`			=: EW_ResetCurLine front;
	(editor1,front)=: GetFrontWindow editor;
	};

GetWdIdOfFrontWindow	:: Editor -> (Editor, EditWdId);
GetWdIdOfFrontWindow editor=:(dk,ds,cb,fi,is,[(id,active):rest])
	=  (editor, id);
GetWdIdOfFrontWindow (dk,ds,cb,fi,is,[])
	= 	abort "GetWdIdOfFrontWindow: There are no windows";

WindowsPresent	:: Editor -> (Editor, Bool);
WindowsPresent editor=:(dk,ds,cb,fi,is,[]) =  (editor,False);
WindowsPresent editor=:(dk,ds,cb,fi,is,ws) =  (editor,True);

SetFrontWindow	:: !EditWindow Editor -> Editor;
SetFrontWindow window (dk,ds,cb,fi,is,[(id,active):rest])
	= 	(dk,ds,cb,fi,is,[(id,window):rest]);
SetFrontWindow window (dk,ds,cb,fi,is,[])
	= 	abort "SetFrontWindow: There are no windows";

RemoveFrontWindow	:: Editor -> Editor;
RemoveFrontWindow (dk,ds,cb,fi,(ids,nid),[(id,active):rest])
	= 	(dk,ds,cb,fi,([id:ids],nid),rest);
RemoveFrontWindow (dk,ds,cb,fi,is,[])
	= 	abort "RemoveFrontWindow: There are no windows";

GetWindow	:: EditWdId Editor -> (Editor, EditWindow);
GetWindow wdid editor=:(dk,ds,cb,fi,is,windows)
	= 	(editor, EWs_GetWindow wdid windows);
	
EWs_GetWindow	:: EditWdId EditWindows -> EditWindow;
EWs_GetWindow wdid [(id,window):wds]
		| wdid == id = 	window;
		= 	EWs_GetWindow wdid wds;
EWs_GetWindow wdid []
		= 	abort ("EWs_GetWindow: Unknown window id: " +++  toString wdid );

SetWindow	:: EditWdId EditWindow Editor -> Editor;
SetWindow wdid window (dk,ds,cb,fi,is,windows)
	=  (dk,ds,cb,fi,is,EWs_SetWindow wdid window windows);
	
EWs_SetWindow	:: EditWdId EditWindow EditWindows -> EditWindows;
EWs_SetWindow wdid window [edit=:(id,old):rest]
		| wdid == id =  [(id,window):rest];
		=  [edit : EWs_SetWindow wdid window rest];

AddWindow	:: EditWdId EditWindow Editor -> Editor;
AddWindow wdid window (dk,ds,cb,fi,is,windows)
	=  (dk,ds,cb,fi,is,[(wdid,window):windows]);

SetWindowInFront	:: EditWdId Editor -> Editor;
SetWindowInFront wdid (dk,ds,cb,fi,is,windows)
	= 	(dk,ds,cb,fi,is, EWs_SetWindowInFront wdid windows []);

EWs_SetWindowInFront	:: EditWdId EditWindows EditWindows -> EditWindows;
EWs_SetWindowInFront wdid [thiswd=:(id,wd):wds] newwds
		| wdid == id = 	Concat [thiswd:newwds] wds;
		= 	EWs_SetWindowInFront wdid wds [thiswd:newwds];
EWs_SetWindowInFront wdid [] newwds
		= 	abort ("EWs_SetWindowInFront: Unknown window id: " +++  toString wdid );

GetWindowIndex	:: String Editor -> (Editor, Int);
GetWindowIndex name editor=:(dk,ds,cb,fi,is,windows)
	=  (editor, EWs_GetWindowIndex 1 (DeCapitalize name) windows);

EWs_GetWindowIndex	:: Int String EditWindows -> Int;
EWs_GetWindowIndex index name [(id,(tx,cp,cl,pathname,sn,ui,tw,wf,fm,nl,sd,ai)) : rest]
	|  DeCapitalize (RemovePath pathname)  > name =  EWs_GetWindowIndex index name rest;
	=  EWs_GetWindowIndex (inc index) name rest;
EWs_GetWindowIndex index name [] =  index;

IsExistingPathname	:: Pathname Editor -> (Editor, Bool, EditWdId);
IsExistingPathname pathname editor=:(dk,ds,cb,fi,is,windows) =  (editor,found,id);
	where {
	(found,id)=: PathnameExists pathname windows;
	};
	
PathnameExists	:: Pathname EditWindows -> (Bool, EditWdId);
PathnameExists path [] =  (False, 0);
PathnameExists path [(id,(tx,cp,cl,pathname,sn,ui,tw,wf,fm,nl,sd,ai)) : rest]
		| path == pathname =  (True, id);
		=  PathnameExists path rest;

EW_GetText	:: EditWindow -> Text;
EW_GetText (text,cp,cl,pn,sn,ui,tw,wf,fm,nl,sd,ai) =  text;

EW_GetCursorPos	:: EditWindow -> CursorPos;
EW_GetCursorPos (tx,cursorpos,cl,pn,sn,ui,tw,wf,fm,nl,sd,ai) =  cursorpos;

EW_GetCurLine	:: EditWindow -> CurLine;
EW_GetCurLine (tx,cp,curline,pn,sn,ui,tw,wf,fm,nl,sd,ai) =  curline;

EW_GetPathname	:: EditWindow -> Pathname;
EW_GetPathname (tx,cp,cl,pathname,sn,ui,tw,wf,fm,nl,sd,ai) =  pathname;

RemovePath	:: Pathname -> String;
RemovePath path
	| found = 	path % (inc position, last);
	= 	path;
		where {
		(found,position)=: LastColon path last;
		last=: dec (# path);
		};

LastColon	:: String Int -> (Bool, Int);
LastColon s i
		| i <= 0 = 	(False,0);
		| DirSeparator ==  s !! i  =  (True, i);
		= 	LastColon s (dec i);

EW_GetSelection	:: EditWindow -> Selection;
EW_GetSelection (tx,cp,cl,pn,selection,ui,tw,wf,fm,nl,sd,ai) =  selection;

IsEmptySelection	:: Selection -> Bool;
IsEmptySelection ((l1,c1,l2,c2),psel) =   l1 == l2  &&  c1 == c2 ;

EW_GetUndoInfo	:: EditWindow -> UndoInfo;
EW_GetUndoInfo (tx,cp,cl,pn,sn,undo,tw,wf,fm,nl,sd,ai) =  undo;

EW_GetTabWidth	:: EditWindow -> TabWidth;
EW_GetTabWidth (tx,cp,cl,pn,sn,ui,tabwidth,wf,fm,nl,sd,ai) =  tabwidth;

EW_GetWindowFont	:: EditWindow -> WindowFont;
EW_GetWindowFont (tx,cp,cl,pn,sn,ui,tw,font,fm,nl,sd,ai) =  font;

EW_GetFontMetrics	:: EditWindow -> FontMetr;
EW_GetFontMetrics (tx,cp,cl,pn,sn,ui,tw,wf,fontmetrics,nl,sd,ai) =  fontmetrics;

EW_GetNrLines	:: EditWindow -> NrLines;
EW_GetNrLines (tx,cp,cl,pn,sn,ui,tw,wf,fm,nrlines,sd,ai) =  nrlines;

EW_GetTextPosition	:: EditWindow -> PartSel;
EW_GetTextPosition (tx,cp,(b,a,l,c),pn,(tsel=:(l1,c1,l2,c2),ps),ui,tw,wf,fm,nl,sd,ai)
	| l1 == l2 && c1 == c2 =  (l,c,l,c);
	=  tsel;

EW_GetActivePos	:: EditWindow -> PartSel;
EW_GetActivePos (tx,curpos	=: ((v,cx,cy,ux)),curline	=: ((b,a,ln,cn)),pn,selection=: (((l1,c1,l2,c2),(bx,by,ex,ey))),ui,tw,wf,fm,nl,sd,ai)| l1 == l2 && c1 == c2 =  (ln,cn,cx,cy);
	| ex == cx && ey == cy =  (l1,c1,bx,by);
	=  (l2,c2,ex,ey);

EW_GetPassivePos	:: EditWindow -> PartSel;
EW_GetPassivePos (tx,curpos	=: ((v,cx,cy,ux)),curline	=: ((b,a,ln,cn)),pn,selection=: (((l1,c1,l2,c2),(bx,by,ex,ey))),ui,tw,wf,fm,nl,sd,ai)| l1 == l2 && c1 == c2 =  (ln,cn,cx,cy);
	| ex == cx && ey == cy =  (l2,c2,ex,ey);
	=  (l1,c1,bx,by);

EW_Saved	:: EditWindow -> Bool;
EW_Saved (tx,cp,cl,pn,sn,ui,tb,wf,fm,nl,saved,ai) =  saved;

EW_AutoIndent	:: EditWindow -> Bool;
EW_AutoIndent (tx,cp,cl,pn,sn,ui,tw,wf,fm,nl,sd,autoindent) =  autoindent;

EW_SetText	:: Text EditWindow -> EditWindow;
EW_SetText text (old,cp,cl,pn,sn,ui,tw,wf,fm,nl,sd,ai)
	=  (text,cp,cl,pn,sn,ui,tw,wf,fm,nl,sd,ai);

EW_SetCursorPos	:: CursorPos EditWindow -> EditWindow;
EW_SetCursorPos cursorpos (tx,old,cl,pn,sn,ui,tw,wf,fm,nl,sd,ai)
	=  (tx,cursorpos,cl,pn,sn,ui,tw,wf,fm,nl,sd,ai);

EW_ToggleCursor	:: EditWindow -> EditWindow;
EW_ToggleCursor (tx,(vis,x,y,u),cl,pn,sn,ui,tw,wf,fm,nl,sd,ai)
	=  (tx,(not vis,x,y,u),cl,pn,sn,ui,tw,wf,fm,nl,sd,ai);

EW_SetCursorVisibility	:: Bool EditWindow -> EditWindow;
EW_SetCursorVisibility vis (tx,(old,x,y,u),cl,pn,sn,ui,tw,wf,fm,nl,sd,ai)
	=  (tx,(vis,x,y,u),cl,pn,sn,ui,tw,wf,fm,nl,sd,ai);

EW_SetCurLine	:: CurLine EditWindow -> EditWindow;
EW_SetCurLine curline (tx,cp,old,pn,sn,ui,tw,wf,fm,nl,sd,ai)
	=  (tx,cp,curline,pn,sn,ui,tw,wf,fm,nl,sd,ai);

EW_ResetCurLine	:: EditWindow -> EditWindow;
EW_ResetCurLine (text,cp,curline=:(bef,aft,linenr,cn),pn,sn,ui,tw,wf,fm,nl,sd,ai)
	=  (text`,cp,curline,pn,sn,ui,tw,wf,fm,nl,sd,ai);
	where {
	text`=: Text_SetLine linenr (Line_GlueLine bef aft) text;
	};

EW_SetPathname	:: Pathname EditWindow -> EditWindow;
EW_SetPathname pathname (tx,cp,cl,old,sn,ui,tw,wf,fm,nl,sd,ai)
	=  (tx,cp,cl,pathname,sn,ui,tw,wf,fm,nl,sd,ai);

EW_SetSelection	:: Selection EditWindow -> EditWindow;
EW_SetSelection selection (tx,cp,cl,pn,old,ui,tw,wf,fm,nl,sd,ai)
	=  (tx,cp,cl,pn,selection,ui,tw,wf,fm,nl,sd,ai);

EW_SetUndoInfo	:: UndoInfo EditWindow -> EditWindow;
EW_SetUndoInfo undo (tx,cp,cl,pn,sn,old,tw,wf,fm,nl,sd,ai)
	=  (tx,cp,cl,pn,sn,undo,tw,wf,fm,nl,sd,ai);

EW_SetTabWidth	:: TabWidth EditWindow -> EditWindow;
EW_SetTabWidth tabwidth (tx,cp,cl,pn,sn,ui,old,wf,fm,nl,sd,ai)
	=  (tx,cp,cl,pn,sn,ui,tabwidth,wf,fm,nl,sd,ai);

EW_SetWindowFont	:: WindowFont EditWindow -> EditWindow;
EW_SetWindowFont font (tx,cp,cl,pn,sn,ui,tw,old,fm,nl,sd,ai)
	=  (tx,cp,cl,pn,sn,ui,tw,font,fm,nl,sd,ai);

EW_SetFontMetrics	:: FontMetr EditWindow -> EditWindow;
EW_SetFontMetrics fontmetrics (tx,cp,cl,pn,sn,ui,tw,wf,old,nl,sd,ai)
	=  (tx,cp,cl,pn,sn,ui,tw,wf,fontmetrics,nl,sd,ai);

EW_SetNrLines	:: NrLines EditWindow -> EditWindow;
EW_SetNrLines nrlines (tx,cp,cl,pn,sn,ui,tw,wf,fm,old,sd,ai)
	=  (tx,cp,cl,pn,sn,ui,tw,wf,fm,nrlines,sd,ai);

EW_SetSaved	:: Saved EditWindow -> EditWindow;
EW_SetSaved saved (tx,cp,cl,pn,sn,ui,tw,wf,fm,nl,old,ai)
	=  (tx,cp,cl,pn,sn,ui,tw,wf,fm,nl,saved,ai);

EW_ToggleAutoIndent	:: EditWindow -> EditWindow;
EW_ToggleAutoIndent (tx,cp,cl,pn,sn,ui,tw,wf,fm,nl,sd,autoindent)
	=  (tx,cp,cl,pn,sn,ui,tw,wf,fm,nl,sd,not autoindent);

EW_SetAutoIndent	:: AutoIndent EditWindow -> EditWindow;
EW_SetAutoIndent autoindent (tx,cp,cl,pn,sn,ui,tw,wf,fm,nl,sd,old)
	=  (tx,cp,cl,pn,sn,ui,tw,wf,fm,nl,sd,autoindent);


/*	Miscellaneous functions */

DeCapitalize	:: String -> String;
DeCapitalize str =  DeCap (dec (# str)) ( toInt FirstSmall  -  toInt FirstCapital ) str;

DeCap	:: Int Int String -> String;
DeCap i diff str
	| i < 0 =  str;
	| char < FirstCapital || char > LastCapital =  DeCap (dec i) diff str;
	=  DeCap (dec i) diff (str := (i, toChar ( toInt char  + diff)));
	where {
	char=: str !! i;
	}; 

Between	:: Int Int Int -> Int;
Between l h x | x < l =  l;
	              | x > h =  h;
	              =  x;

Length_new	:: [t] -> Int;
Length_new [] =  0;
Length_new [f:r] =  inc (Length_new r);

Reverse	:: [t] -> [t];
Reverse list =  Rev2 list [];

Rev2 :: [t] [t] -> [t];
Rev2 [] res =  res;
Rev2 [f:r] res =  Rev2 r [f:res];

Concat	:: [t] [t] -> [t];
Concat [] list2 =  list2;
Concat [el:rest] list2 =  [el : Concat rest list2];

ApplyFunctions	:: [t -> t] !t -> t;
ApplyFunctions [] x =  x;		
ApplyFunctions [f:r] x =  ApplyFunctions r (f x);

