implementation module windowDef

/* The type definitions for the window device.
*/

import commonDef, StdInt
from deltaPicture import Picture, DrawFunction, UpdateArea

		

:: WindowDef * s * io
		= ScrollWindow WindowId WindowPos WindowTitle ScrollBarDef ScrollBarDef
		  PictureDomain MinimumWindowSize InitialWindowSize
		  (UpdateFunction s) [WindowAttribute s io]
	|  FixedWindow  WindowId WindowPos WindowTitle
		  PictureDomain
		  (UpdateFunction s) [WindowAttribute s io]
 
:: WindowId          :== Int
:: WindowPos         :== (!Int, !Int)
:: WindowTitle       :== String

:: ScrollBarDef      = ScrollBar ThumbValue ScrollValue
:: ThumbValue        = Thumb  Int
:: ScrollValue       = Scroll Int

:: MinimumWindowSize :== (!Int, !Int)
:: InitialWindowSize :== (!Int, !Int)
// :: UpdateArea        :== [Rectangle]
:: UpdateFunction * s        :== UpdateArea -> s -> (s,[DrawFunction]) 
:: GoAwayFunction * s * io :== s -> *( io -> (s, io)) 
 
:: WindowAttribute * s * io
		= Activate   (WindowFunction s io)
	|  Deactivate (WindowFunction s io)
	|  GoAway     (WindowFunction s io)
	|  Mouse      SelectState (MouseFunction    s io)
	|  Keyboard   SelectState (KeyboardFunction s io)
	|  Cursor     CursorShape
	|  StandByWindow

:: WindowFunction   * s * io :== s -> *( io -> (s, io) )
:: KeyboardFunction * s * io :== KeyboardState ->  s -> *( io -> (s, io))  
:: MouseFunction    * s * io :== MouseState ->     s ->  *(io -> (s, io))  
 
:: CursorShape = StandardCursor | BusyCursor     | IBeamCursor |
		  CrossCursor    | FatCrossCursor | ArrowCursor |
		  HiddenCursor

		

IsScrollWindow  :: !(WindowDef s io) -> Bool
IsScrollWindow (ScrollWindow id pos t h v pd min init f as) = True
IsScrollWindow window = False

WindowDef_WindowId  :: !(WindowDef s io) -> WindowId
WindowDef_WindowId (ScrollWindow id pos t h v pd min init f as) = id
WindowDef_WindowId (FixedWindow  id pos t     pd          f as) = id
		
WindowDef_Position  :: !(WindowDef s io) -> WindowPos
WindowDef_Position (ScrollWindow id pos t h v pd min init f as) = pos
WindowDef_Position (FixedWindow  id pos t     pd          f as) = pos
		
WindowDef_Title :: !(WindowDef s io) -> String
WindowDef_Title (ScrollWindow id pos t h v pd min init f as) = t
WindowDef_Title (FixedWindow  id pos t     pd          f as) = t

WindowDef_ScrollBarDefs :: !(WindowDef s io) -> (!ScrollBarDef, !ScrollBarDef)
WindowDef_ScrollBarDefs (ScrollWindow id pos t h v pd min init f as) = (h, v)

WindowDef_PictureDomain :: !(WindowDef s io) -> PictureDomain
WindowDef_PictureDomain (ScrollWindow id pos t h v pd min init f as) = pd
WindowDef_PictureDomain (FixedWindow  id pos t     pd          f as) = pd

WindowDef_MinimumSize   :: !(WindowDef s io) -> MinimumWindowSize
WindowDef_MinimumSize (ScrollWindow id pos t h v pd min init f as) = min
WindowDef_MinimumSize (FixedWindow  id pos t     pd=: (((xl,yl), (xr,yr)))          f as)= (xr - xl, yr - yl)

WindowDef_InitialSize   :: !(WindowDef s io) -> InitialWindowSize
WindowDef_InitialSize (ScrollWindow id pos t h v pd min init f as) = init
WindowDef_InitialSize (FixedWindow  id pos t     pd=: (((xl,yl), (xr,yr)))          f as)= (xr - xl, yr - yl)

WindowDef_Update    :: !(WindowDef s io) -> UpdateFunction s
WindowDef_Update (ScrollWindow id pos t h v pd min init f as) = f
WindowDef_Update (FixedWindow  id pos t     pd          f as) = f

WindowDef_HasAttribute  :: !(WindowDef s io) !(WindowAttribute s io) -> Bool
WindowDef_HasAttribute (ScrollWindow id pos t h v pd min init f as) a
		= WindowAttributesHaveAttribute as a
WindowDef_HasAttribute (FixedWindow  id pos t     pd          f as) a
		= WindowAttributesHaveAttribute as a

WindowDef_IsStandBy :: !(WindowDef s io) -> Bool
WindowDef_IsStandBy (ScrollWindow id pos t h v pd min init f as)
		= WindowAttributesHaveAttribute as StandByWindow
WindowDef_IsStandBy (FixedWindow id pos t pd f as)
		= WindowAttributesHaveAttribute as StandByWindow

WindowAttributesHaveAttribute   :: ![WindowAttribute s io] !(WindowAttribute s io) -> Bool
WindowAttributesHaveAttribute [Activate a           : as] (Activate   a` )     = True
WindowAttributesHaveAttribute [Deactivate   d       : as] (Deactivate     d` ) = True
WindowAttributesHaveAttribute [GoAway       g       : as] (GoAway         g` ) = True
WindowAttributesHaveAttribute [Keyboard ks kf       : as] (Keyboard ks` kf`)   = True
WindowAttributesHaveAttribute [Mouse        ms mf   : as] (Mouse     ms` mf`)  = True
WindowAttributesHaveAttribute [Cursor       s       : as] (Cursor         s` ) = True
WindowAttributesHaveAttribute [StandByWindow        : as] StandByWindow        = True
WindowAttributesHaveAttribute [a : as] a`   = WindowAttributesHaveAttribute as a`
WindowAttributesHaveAttribute as a          = False

WindowDef_Activate  :: !(WindowDef s io) -> WindowFunction s io
WindowDef_Activate (ScrollWindow id pos t h v pd min init f as)
		= GetWindowAttributeFunction as (Activate LazyWindowFunction)
WindowDef_Activate (FixedWindow id pos t pd f as)
		= GetWindowAttributeFunction as (Activate LazyWindowFunction)

GetWindowAttributeFunction  :: ![WindowAttribute s io] !(WindowAttribute s io)
		->  WindowFunction s io
GetWindowAttributeFunction [Activate    a : as] (Activate   a`) = a
GetWindowAttributeFunction [Deactivate  d : as] (Deactivate d`) = d
GetWindowAttributeFunction [GoAway      g : as] (GoAway     g`) = g
GetWindowAttributeFunction [a : as] a`  = GetWindowAttributeFunction as a`
GetWindowAttributeFunction as a         = LazyWindowFunction

LazyWindowFunction  ::  * s  * io -> (*s, *io)
LazyWindowFunction s io = (s, io)
		
WindowDef_Deactivate    :: !(WindowDef s io) -> WindowFunction s io
WindowDef_Deactivate (ScrollWindow id pos t h v pd min init f as)
		= GetWindowAttributeFunction as (Deactivate LazyWindowFunction)
WindowDef_Deactivate (FixedWindow id pos t pd f as)
		= GetWindowAttributeFunction as (Deactivate LazyWindowFunction)

WindowDef_GoAway    :: !(WindowDef s io) -> WindowFunction s io
WindowDef_GoAway (ScrollWindow id pos t h v pd min init f as)
		= GetWindowAttributeFunction as (GoAway LazyWindowFunction)
WindowDef_GoAway (FixedWindow id pos t pd f as)
		= GetWindowAttributeFunction as (GoAway LazyWindowFunction)

WindowDef_Cursor    :: !(WindowDef s io) -> CursorShape
WindowDef_Cursor (ScrollWindow id pos t h v pd min init f as)
		= GetWindowAttributeCursor as
WindowDef_Cursor (FixedWindow id pos t pd f as)
		= GetWindowAttributeCursor as

GetWindowAttributeCursor    :: ![WindowAttribute s io] -> CursorShape
GetWindowAttributeCursor [Cursor shape : as] = shape
GetWindowAttributeCursor [a : as]   = GetWindowAttributeCursor as
GetWindowAttributeCursor as         = StandardCursor

WindowDef_Keyboard  :: !(WindowDef s io) -> (!SelectState, !KeyboardFunction s io)
WindowDef_Keyboard (ScrollWindow id pos t h v pd min init f as)
		= GetWindowAttributeKeyboard as
WindowDef_Keyboard (FixedWindow id pos t pd f as)
		= GetWindowAttributeKeyboard as

WindowDef_Mouse :: !(WindowDef s io) -> (!SelectState, !MouseFunction s io)
WindowDef_Mouse (ScrollWindow id pos t h v pd min init f as)
		= GetWindowAttributeMouse as
WindowDef_Mouse (FixedWindow id pos t pd f as)
		= GetWindowAttributeMouse as

GetWindowAttributeKeyboard  :: ![WindowAttribute s io] -> (!SelectState, !KeyboardFunction s io)
GetWindowAttributeKeyboard [Keyboard ks kf : as] = (ks, kf)
GetWindowAttributeKeyboard [a : as] = GetWindowAttributeKeyboard as
GetWindowAttributeKeyboard as       = (Unable, LazyDeviceFunction)

GetWindowAttributeMouse :: ![WindowAttribute s io] -> (!SelectState, !MouseFunction s io)
GetWindowAttributeMouse [Mouse ms mf : as] = (ms, mf)
GetWindowAttributeMouse [a : as]    = GetWindowAttributeMouse as
GetWindowAttributeMouse as          = (Unable, LazyDeviceFunction)

LazyDeviceFunction  :: t * s * io -> (*s, *io)
LazyDeviceFunction t s io = (s, io)
		
ScrollBarDef_Values :: !ScrollBarDef -> (!Int, !Int)
ScrollBarDef_Values (ScrollBar (Thumb t) (Scroll s)) = (t, s)

WindowDef_SetPictureDomain  :: !(WindowDef s io) !PictureDomain -> WindowDef s io
WindowDef_SetPictureDomain (ScrollWindow id pos t h v pd min init f as) pd_new
		= ScrollWindow id pos t h v pd_new min init f as
WindowDef_SetPictureDomain (FixedWindow id pos t pd f as) pd_new
		= FixedWindow id pos t pd_new f as

WindowDef_SetUpdate :: !(WindowDef s io) !(UpdateFunction s) -> WindowDef s io
WindowDef_SetUpdate (ScrollWindow id pos t h v pd min init f as) f_new
		= ScrollWindow id pos t h v pd min init f_new as
WindowDef_SetUpdate (FixedWindow id pos t pd f as) f_new
		= FixedWindow id pos t pd f_new as

WindowDef_SetActivate   :: !(WindowDef s io) !(WindowFunction s io) -> WindowDef s io
WindowDef_SetActivate (ScrollWindow id pos t h v pd min init f as) a
		= let! 
			strict1
		  in ScrollWindow id pos t h v pd min init f strict1
		  where 
		  strict1=(SetWindowAttributeFunction as (Activate a))
WindowDef_SetActivate (FixedWindow id pos t pd f as) a
		= let! 
			strict1
		  in FixedWindow id pos t pd f strict1
		  where 
		  strict1=(SetWindowAttributeFunction as (Activate a))
				
		

WindowDef_SetDeactivate :: !(WindowDef s io) !(WindowFunction s io) -> WindowDef s io
WindowDef_SetDeactivate (ScrollWindow id pos t h v pd min init f as) da
		= let! 
			strict1
		  in ScrollWindow id pos t h v pd min init f strict1
		  where 
		  strict1=(SetWindowAttributeFunction as (Deactivate da))
WindowDef_SetDeactivate (FixedWindow id pos t pd f as) da
		= let! 
			strict1
		  in FixedWindow id pos t pd f strict1
		  where 
		  strict1=(SetWindowAttributeFunction as (Deactivate da))
				
		

WindowDef_SetGoAway :: !(WindowDef s io) !(WindowFunction s io) -> WindowDef s io
WindowDef_SetGoAway (ScrollWindow id pos t h v pd min init f as) ga
		= let! 
			strict1
		  in ScrollWindow id pos t h v pd min init f strict1
		  where 
		  strict1=(SetWindowAttributeFunction as (GoAway ga))
WindowDef_SetGoAway (FixedWindow id pos t pd f as) ga
		= let! 
			strict1
		  in FixedWindow id pos t pd f strict1
		  where 
		  strict1=(SetWindowAttributeFunction as (GoAway ga))
				
		

SetWindowAttributeFunction  :: ![WindowAttribute s io] !(WindowAttribute s io)
		->  [WindowAttribute s io]
SetWindowAttributeFunction [Activate    a : as] f=:(Activate        a`) = [f : as]
SetWindowAttributeFunction [Deactivate  d : as] f=:(Deactivate  d`) = [f : as]
SetWindowAttributeFunction [GoAway      g : as] f=:(GoAway          g`) = [f : as]
SetWindowAttributeFunction [a : as] a`
		= let! 
			strict1
		  in [a : strict1]
		  where 
		  strict1=SetWindowAttributeFunction as a`
SetWindowAttributeFunction as a`        = [a`]

WindowDef_SetScrollBarDefs  :: !(WindowDef s io) !(!(!Int,!Int), !(!Int,!Int)) -> WindowDef s io
WindowDef_SetScrollBarDefs (ScrollWindow id pos t h v pd min init f as)
		  ((h_thumb, h_scroll), (v_thumb, v_scroll))
		= ScrollWindow id pos t h_new v_new pd min init f as
		  where 
		  h_new=: ScrollBar (Thumb h_thumb) (Scroll h_scroll)
		  v_new=: ScrollBar (Thumb v_thumb) (Scroll v_scroll)
				
WindowDef_SetScrollBarDefs window scrollbars = window

WindowDef_SetMinimumSize    :: !(WindowDef s io) !MinimumWindowSize -> WindowDef s io
WindowDef_SetMinimumSize (ScrollWindow id pos t h v pd min init f as) min_new
		= ScrollWindow id pos t h v pd min_new init f as
WindowDef_SetMinimumSize window min_size = window
		
WindowDef_SetCursor :: !(WindowDef s io) !CursorShape -> WindowDef s io
WindowDef_SetCursor (ScrollWindow id pos t h v pd min init f as) shape
		= let! 
			strict1
		  in ScrollWindow id pos t h v pd min init f strict1
		  where 
		  strict1=(SetWindowCursor as (Cursor shape))
WindowDef_SetCursor (FixedWindow id pos t pd f as) shape
		= let! 
			strict1
		  in FixedWindow id pos t pd f strict1
		  where 
		  strict1=(SetWindowCursor as (Cursor shape))
				
		
		
SetWindowCursor :: ![WindowAttribute s io] !(WindowAttribute s io) -> [WindowAttribute s io]
SetWindowCursor [Cursor shape : as] cursor = [cursor : as]
SetWindowCursor [a : as] cursor
		= let! 
			strict1
		  in [a : strict1]
		  where 
		  strict1=SetWindowCursor as cursor
SetWindowCursor as       cursor = [cursor]

WindowDef_SetKeyboard   :: !(WindowDef s io) !SelectState !(KeyboardFunction s io)
		->  WindowDef s io
WindowDef_SetKeyboard (ScrollWindow id pos t h v pd min init f as) ks kf
		= let! 
			strict1
		  in ScrollWindow id pos t h v pd min init f strict1
		  where 
		  strict1=(SetWindowAttributeDevice as (Keyboard ks kf))
WindowDef_SetKeyboard (FixedWindow id pos t pd f as) ks kf
		= let! 
			strict1
		  in FixedWindow id pos t pd f strict1
		  where 
		  strict1=(SetWindowAttributeDevice as (Keyboard ks kf))
				
		

WindowDef_SetMouse  :: !(WindowDef s io) !SelectState !(MouseFunction s io)
		->  WindowDef s io
WindowDef_SetMouse (ScrollWindow id pos t h v pd min init f as) ms mf
		= let! 
			strict1
		  in ScrollWindow id pos t h v pd min init f strict1
		  where 
		  strict1=(SetWindowAttributeDevice as (Mouse ms mf))
WindowDef_SetMouse (FixedWindow id pos t pd f as) ms mf
		= let! 
			strict1
		  in FixedWindow id pos t pd f strict1
		  where 
		  strict1=(SetWindowAttributeDevice as (Mouse ms mf))
				
		

SetWindowAttributeDevice    :: ![WindowAttribute s io] !(WindowAttribute s io)
		->  [WindowAttribute s io]
SetWindowAttributeDevice [Keyboard  ks kf : as] (Keyboard ks` kf`) = [Keyboard ks` kf` : as]
SetWindowAttributeDevice [Mouse     ms mf : as] (Mouse   ms` mf`) = [Mouse     ms` mf` : as]
SetWindowAttributeDevice [a : as] a`
		= let! 
			strict1
		  in [a : strict1]
		  where 
		  strict1=SetWindowAttributeDevice as a`
SetWindowAttributeDevice as a`          = as

WindowDef_FinalMinimumSize  :: !(WindowDef s io) -> MinimumWindowSize
WindowDef_FinalMinimumSize (ScrollWindow id pos t h v pd min init f as) = (48, 1)
WindowDef_FinalMinimumSize (FixedWindow  id pos t     pd          f as) = (32, 1)

