definition module deltaTimer


//  Version 0.8.3b

//
//  Operations on the TimerDevice. 
//


import deltaIOSystem
from   ioState import IOState


TicksPerSecond :== 60    
    

::  CurrentTime :== (!Int, !Int, !Int)
// (hours (0-23), minutes (0-59), seconds (0-59))

::  CurrentDate :== (!Int, !Int, !Int, !Int)
// (year, month (1-12), day (1-31), day of week (1-7, Sunday=1, Saturday=7))


    

OpenTimer   :: !(TimerDef s (IOState s)) !(IOState s) -> IOState s
CloseTimer  :: !TimerId !(IOState s) -> IOState s

/*  Opening and closing of timers. In case already a timer exists with the
    given new TimerId, the timer is not opened. Closing the timer with an
    unknown TimerId has no effect. */

EnableTimer ::            !TimerId !(IOState s) -> IOState s
DisableTimer    ::        !TimerId !(IOState s) -> IOState s
ChangeTimerFunction :: !TimerId !(TimerFunction s (IOState s)) !(IOState s) -> IOState s
SetTimerInterval    ::    !TimerId !TimerInterval !(IOState s) -> IOState s

/*  Enable, disable and change the TimerFunction and TimerInterval
    of the TimerDevice. The TimerInterval must at least be zero.
    Negative TimerIntervals are effectively set to zero. */

Wait    ::  !TimerInterval x -> x
UWait   :: !TimerInterval * x -> *x

/*  Wait/UWait suspend the interaction for TimerInterval ticks. */

GetTimerBlinkInterval   :: !(IOState s) -> (!TimerInterval, !IOState s)

/*  Returns the TimerInteval that should elaps between blinks of e.g.
    a cursor. This interval can change during the interaction! */

GetCurrentTime  ::           !(IOState s) -> (!CurrentTime,  !IOState s)
GetCurrentDate  ::           !(IOState s) -> (!CurrentDate,  !IOState s)

/*  GetCurrentTime and GetCurrentDate return the current time and date. */

