implementation module commonDef

//
// Common type for the event I/O system.
//

from deltaPicture import Rectangle, Point

:: ItemTitle     :== String

:: SelectState     = Able | Unable
:: MarkState       = Mark | NoMark

:: KeyboardState :== (!KeyCode, !KeyState, !Modifiers)
:: KeyCode       :== Char
:: KeyState        = KeyUp | KeyDown | KeyStillDown

:: MouseState    :== (!MousePosition, !ButtonState, !Modifiers)
:: MousePosition :== (!Int, !Int)
:: ButtonState     = ButtonUp | ButtonDown | ButtonDoubleDown |
		  ButtonTripleDown | ButtonStillDown

/* Modifiers indicates the meta keys that have been pressed (TRUE)
		  or not (FALSE): (Shift, Control, Alt)
*/
:: Modifiers     :== (!Bool,!Bool,!Bool,!Bool)

:: PictureDomain :== Rectangle

SelectStateEqual:: !SelectState !SelectState -> Bool
SelectStateEqual Able   Able   = True
SelectStateEqual Unable Unable = True
SelectStateEqual s t           = False

MarkEqual :: !MarkState !MarkState -> Bool
MarkEqual Mark   Mark   = True
MarkEqual NoMark NoMark = True
MarkEqual m n           = False

Enabled:: !SelectState -> Bool
Enabled Able   = True 
Enabled Unable = False
