definition module Best.Shares

from iTasks.WF.Definition import :: Task
from Data.Either import :: Either
from Data.Map import :: Map
from Data.Maybe import :: Maybe
from iTasks.Extensions.DateTime import :: DateTime
from iTasks.SDS.Definition import :: SimpleSDSLens, :: SDSLens, :: SDSSource, :: SDSParallel
from mTask.Interpret.Device.TCP import :: TCPSettings

from Best.Types import :: BestDevice, :: BestDeviceReadingData, :: BestDeviceReading

/*
 * Initialize the database
 */
initializeDatabase :: Task ()

/*
 * The store mapping the unique device names to their connection settings
 */
devicesStore :: SDSLens () [String] ()

/*
 * The store mapping to a single device from the devicesStore
 */
deviceStore :: SDSParallel String BestDevice BestDevice

/*
 * The store mapping to the readings of a specific device
 * You read all the readings
 * You write only the data and that data is automatically stamped with the datetime
 */
deviceReadingStore :: SDSLens String [BestDeviceReading] BestDeviceReadingData
