implementation module mTask.Interpret.Peripheral

import StdEnv

import Data.Func
import Data.List
import Data.Functor
import Data.Functor.Identity
import Data.Monoid
import Control.Monad
import Control.Monad.State
import Control.Monad.Writer
import Control.Applicative

import mTask.Interpret.DSL
import mTask.Interpret.UInt
import mTask.Language

derive class gCons BCPeripheral

derive toByteCode BCPeripheral, DHTtype

derive fromByteCode BCPeripheral, DHTtype

instance dht (StateT BCState (WriterT [BCInstr] Identity)) where
	DHT p type def = {main
		=   gets nextDHT
		<*  modify (\s->{s & bcs_hardware=s.bcs_hardware ++ [BCDHT (pin p) type]})
		>>= unmain o def o pure
		}
	temperature dht = dht >>= \(Dht i)->tell` [BCMkTask $ BCDHTTemp $ fromInt i]
	humidity dht = dht >>= \(Dht i)->tell` [BCMkTask $ BCDHTHumid $ fromInt i]

nextDHT :: BCState -> DHT
nextDHT st=:{bcs_hardware=p} = Dht $ fromInt $ length [()\\(BCDHT _ _)<-p]

instance LEDMatrix (StateT BCState (WriterT [BCInstr] Identity)) where
	ledmatrix data clock def = {main
		=   gets nextLEDMatrix
		<*  modify (\s->{s & bcs_hardware=s.bcs_hardware ++ [BCLEDMatrix (pin data) (pin clock)]})
		>>= unmain o def o pure
		}
	LMDot m x y s = m >>= \(LEDMatrix i)->x >>| y >>| s >>| tell` [BCMkTask $ BCLEDMatrixDot $ fromInt i]
	LMIntensity m x = m >>= \(LEDMatrix i)->x >>| tell` [BCMkTask $ BCLEDMatrixIntensity $ fromInt i]
	LMClear m = m >>= \(LEDMatrix i)->tell` [BCMkTask $ BCLEDMatrixClear $ fromInt i]
	LMDisplay m = m >>= \(LEDMatrix i)->tell` [BCMkTask $ BCLEDMatrixDisplay $ fromInt i]

nextLEDMatrix :: BCState -> LEDMatrix
nextLEDMatrix st=:{bcs_hardware=p} = LEDMatrix (fromInt $ length [()\\(BCLEDMatrix _ _)<-p])

instance i2cbutton (StateT BCState (WriterT [BCInstr] Identity)) where
	i2cbutton addr def = {main
		=   gets nextI2CButton
		<*  modify (\s->{s & bcs_hardware=s.bcs_hardware ++ [BCI2CButton (UInt8 addr)]})
		>>= unmain o def o pure
		}
	AButton m = m >>= \(I2CButton i)->tell` [BCMkTask (BCAButton (fromInt i))]
	BButton m = m >>= \(I2CButton i)->tell` [BCMkTask (BCBButton (fromInt i))]

nextI2CButton :: BCState -> I2CButton
nextI2CButton st=:{bcs_hardware=p} = I2CButton (fromInt $ length [()\\(BCI2CButton _)<-p])

instance LightSensor (StateT BCState (WriterT [BCInstr] Identity))
where
	lightsensor addr def = {main
		= gets nextLightSensor
		<* modify (\s -> {s & bcs_hardware=s.bcs_hardware ++ [BCLightSensor (UInt8 addr)]})
		>>= unmain o def o pure
		}
	light ls = ls >>= \(LightSensor i) -> tell` [BCMkTask (BCGetLight (fromInt i))]

nextLightSensor :: BCState -> LightSensor
nextLightSensor st=:{bcs_hardware=p} = LightSensor (fromInt $ length [()\\(BCLightSensor _) <- p])

instance AirQualitySensor (StateT BCState (WriterT [BCInstr] Identity))
where
	airqualitysensor addr def = {main
		= gets nextAirQualitySensor
		<* modify (\s -> {s & bcs_hardware=s.bcs_hardware ++ [BCAirQualitySensor (fromInt addr)]})
		>>= unmain o def o pure
		}
	setEnvironmentalData humid temp aqs = humid >>| temp >>| aqs >>= \(AirQualitySensor i)->tell` [BCMkTask (BCSetEnvironmentalData (fromInt i))]
	tvoc aqs = aqs >>= \(AirQualitySensor s) -> tell` [BCMkTask (BCTVOC (fromInt s))]
	co2 aqs = aqs >>= \(AirQualitySensor s) -> tell` [BCMkTask (BCCO2 (fromInt s))]

nextAirQualitySensor :: BCState -> AirQualitySensor
nextAirQualitySensor st=:{bcs_hardware=p} = AirQualitySensor (fromInt $ length [()\\(BCAirQualitySensor _) <- p])
