definition module mTask.Interpret.Peripheral

from mTask.Interpret.ByteCodeEncoding import generic fromByteCode, generic toByteCode
from mTask.Interpret.UInt import :: UInt8

import mTask.Interpret.DSL
import mTask.Language

:: BCPeripheral
	= BCDHT Pin DHTtype
	| BCLEDMatrix Pin Pin
	| BCI2CButton UInt8
	| BCLightSensor UInt8
	| BCAirQualitySensor UInt8
	//= E.p: BCPeripheral p & iTask p & fromByteCode p & toByteCode p

derive fromByteCode BCPeripheral
derive toByteCode BCPeripheral

instance dht (StateT BCState (WriterT [BCInstr] Identity))
instance LEDMatrix (StateT BCState (WriterT [BCInstr] Identity))
instance i2cbutton (StateT BCState (WriterT [BCInstr] Identity))
instance LightSensor (StateT BCState (WriterT [BCInstr] Identity))
instance AirQualitySensor (StateT BCState (WriterT [BCInstr] Identity))
