SHELL:=bash
CPM?=cpm

.SECONDARY: $(addsuffix .prj,$(BINARIES))
.PHONY: clean

ifeq ($(OS), Windows_NT)
DETECTED_OS?=Windows
else
DETECTED_OS?=POSIX
endif

ifeq ($(DETECTED_OS), Windows)
LIBDIR=Libraries
else
LIBDIR=lib
endif

.PHONY: clean clobber

all: $(BINARIES)

%: %.prj %.icl
	$(CPM) $< |& grep -v Analyzing

%.prj: mtask-$(DETECTED_OS).prt
	$(CPM) project $* create $<

%.prj: %.prj.default
	cp $< $@

%.prj:
	$(CPM) project $(basename $@) create
	$(CPM) project $@ target iTasks
	$(CPM) project $@ root ..
	$(CPM) project $@ exec "$$PWD"/$(basename $@)
	$(CPM) project $@ path add "$$PWD/../library/"
	$(CPM) project $@ path add "$$PWD/../library/CleanSerial/src"
	$(CPM) project $@ path add "$$PWD/../library/CleanSerial/src/$(DETECTED_OS)"
	$(CPM) project $@ path add "$$PWD"
	$(CPM) project $@ path add "$$CLEAN_HOME/$(LIBDIR)/Gast"
	$(CPM) project $@ set -dynamics -h 500M -s 20M -b

clean:
	$(RM) -r $(BINARIES) $(foreach suf,.bc .pbc .prj .tar.gz -sapl -data -www,$(addsuffix $(suf),$(BINARIES)))
