module best

//import iTasks.UI.Editor.Containers
//import StdEnv
//
import Data.Func
import Data.List
//import Data.Either
import Data.Tuple
import qualified Data.Map as DM
//import Data.Map.GenJSON
//
import iTasks
import iTasks.Extensions.DateTime
//import iTasks.Extensions.Collection
//
//import mTask.Show
import mTask.Interpret
import mTask.Interpret.Device.TCP
//
import Best.Types
import Best.Shares
import Best.Util
//import Text.HTML
import Text

import code from library "-lsqlite3", library "-lmariadb"

Start w = doTasks
	//The frontend is started when the user connects to the server
	[ onRequest "/" frontend
//	//The management interface is started with the /manage url
	, onRequest "/manage" manage
//	//The backend is started on load
	, onStartup (initializeDatabase >-| backend)
	] w

/*
 * Manage the devices
 */
manage :: Task ()
manage
	=   editChoiceWithShared [ChooseFromList id] devicesStore Nothing <<@ Title "Select a device"
	>>* [ OnAction (Action "New")    $ always   $ newDevice
	    , OnAction (Action "Edit")   $ hasValue $ updDevice
	    , OnAction (Action "Delete") $ hasValue $ \_->viewInformation [] "Not implemented" @? const NoValue
	    ]
where
	newDevice = enterInformation [] >>? \(n, d)->set d (sdsFocus n deviceStore)
		>-| manage
	updDevice n = get (sdsFocus n deviceStore)
		>>- tune (Title n) o updateInformation []
		>>? \d->set d (sdsFocus n deviceStore)
		>-| manage

/*
 * The frontend offers the view to the sensor data
 */
frontend = tune (Title "Current readings")
	$ whileUnchanged devicesStore \devices->case devices of
		[] = ApplyLayout frameCompact
			@>> Title "No devices yet"
			@>> viewInformation [] "Please add devices first"
			@? const NoValue
		m = allTasks (map viewDeviceReadings m)
where
	viewDeviceReadings d
		= tune (Label d)
		$ viewSharedInformation [ViewAs listToMaybe] (sdsFocus d deviceReadingStore)

/*
 * The backend  monitors the devices and (re)starts/stops them when needed
 */
backend :: Task ()
backend = parallel [(Embedded, watcher)] [] @! ()
where
	/*
	 * The watcher monitors the tasks and adds a deviceMonitor when a device is
	 * added
	 */
	watcher :: (SharedTaskList ()) -> Task ()
	watcher stl
		=    get (sdsFocus {fullTaskListFilter & includeManagementAttributes=True} stl)
		>>- \ctl->watch (mapRead (newDevice (snd ctl)) devicesStore)
		>>* [OnValue $ ifValue (not o isEmpty) $
			\name->get (sdsFocus (hd name) deviceStore)
		>>- \d->traceValue ("Adding a task for " +++ hd name)
		>-|     appendTask (Detached True ('DM'.singleton "bestdevicename" $ JSONString $ hd name)) (\_->deviceMonitor (hd name) d) stl
		] >-| watcher stl

	/*
	 * The predicate for whether there are new devices
	 */
	newDevice :: [TaskListItem ()] [String] -> [String]
	newDevice tasklist devices
		# runningTasks = catMaybes ['DM'.get "bestdevicename" managementAttributes\\{TaskListItem|managementAttributes}<-tasklist]
		= filter (\name->notElem (JSONString name) runningTasks) devices

	/*
	 * The task monitoring a single device, it is automatically stopped when
	 * the device is removed
	 */
	deviceMonitor :: String BestDevice -> Task ()
	deviceMonitor name d=:{TCPSettings|host,port}
		//This will throw an exception when the device is removed and therefore stop the composition
		=  catchAll (watch (sdsFocus name deviceStore) @! ()) (\_->return ())
		-|| deviceTask
	where
		deviceTask = try
			(withDevice {TCPSettings|host=host,port=port} True $ liftmTask $ bestmTask name)
			\e->case e of
				MTEUnexpectedDisconnect
					=   traceValue (name +++ ": Disconnected, retrying in ten seconds...")
					>-| waitForTimer False 10 >-| deviceTask
				MTESyncException e
					=   traceValue (name +++ ": Couldn't connect to " +++ host +++ ":" +++ toString port +++ ", retrying in a minute...")
					>-| waitForTimer False 60 >-| deviceTask
				MTEUnsupportedPeripheral a b
					=   traceValue (name +++ ": Error setting up peripheral " +++ toString a +++ " " +++ toString b +++ ", please check the device's hardware and firmware, retrying in an hour...")
					>-| waitForTimer False 3600 >-| deviceTask
				e = throw $ "Error " +++ toString e +++ " in the mTask execution... I cannot recover from this"

/*
 * The mTask task communicating the sensor values to the server
 * TODO improve
 */
bestmTask :: String -> Main (MTask v ()) | mtask, dht, liftsds, LightSensor, AirQualitySensor v
bestmTask name
	=  DHT D4 DHT22 \dht->
	   PIR D3 \pir->
	   lightsensor 0x23 \ls->
	   airqualitysensor 0x5B \aqs->
	   soundDetector D1 A0 \ss->
	   liftsds \readingSds=iTasksReadingSds
	In {main=rpeat (
		     temperature dht .&&. humidity dht .&&. motion pir .&&. light ls .&&. co2 aqs .&&. soundLevel ss
		>>~. setSds readingSds
		)
	}
where
	iTasksReadingSds :: SimpleSDSLens (Real, (Real, (Bool, (Real, (Int, Int)))))
	iTasksReadingSds = mapReadWrite
		( \r->case r of
			[] = (0.0, (0.0, (False, (0.0, (0, 0)))))
			[(dt, r):_] = (r.temperature, (r.humidity, (r.motion, (r.light, (r.co2, r.noise)))))
		, \(t, (h, (m, (l, (c, n))))) _-> Just {humidity=h, temperature=t, motion=m, light=l, co2=c, noise=n}
		) Nothing (sdsFocus name deviceReadingStore)
