implementation module Best.Util

import StdEnv
import iTasks
import Data.Func

login :: (Task a) -> Task a | iTask a
login task
	=   Title "Log in or register"
	@>> Hint "Please enter your credentials"
	@>> enterInformation []
	>>* [ OnAction (Action "Register") $ hasValue \credentials->
			catchAll
				(createUser {UserAccount|credentials=credentials,title=Nothing,roles=[]}
					>-| viewInformation [] "Account successfully created")
				(viewInformation [])
			>?| login task
		, OnAction (Action "Continue") $ hasValue \{Credentials|username,password}->
			authenticateUser username password False
			>>- maybe
				(viewInformation [] "Login failed" >?| login task)
				(flip workAs task)
		]
