definition module Best.Types

from Data.Either import :: Either
from Data.GenDefault import generic gDefault
from Data.GenEq import generic gEq
from Data.Maybe import :: Maybe
from Text.GenJSON import generic JSONEncode, generic JSONDecode, :: JSONNode
from iTasks.Extensions.DateTime import :: DateTime
from iTasks.Internal.Generic.Visualization import generic gText, :: TextFormat
from iTasks.UI.Editor.Generic import generic gEditor, :: Editor
from iTasks.WF.Definition import class iTask
from mTask.Interpret.Device.TCP import :: TCPSettings

:: BestDeviceReadingData =
	{ temperature :: Real
	, humidity    :: Real
	, noise       :: Int
	, light       :: Real
	, motion      :: Bool
	, co2         :: Int
	}

:: BestDevice :== TCPSettings
:: BestDeviceReading :== (DateTime, BestDeviceReadingData)

derive gDefault BestDeviceReadingData
derive class iTask BestDeviceReadingData
