definition module Interpret.Device.Simulator

import iTasks

from Interpret.Compile import :: BCShareSpec
import Interpret.Device
import Interpret.Device.Simulator.Energy
import Interpret.Device.Simulator.Interpret
import Interpret.Device.Simulator.Rewrite
import Interpret.Device.Simulator.Stack
import Interpret.Device.Simulator.State
import Interpret.Instructions
import Interpret.UInt

:: SimChannels sds :== sds () Channels Channels

/**
 * Settings that are passed to the Interpreter
 */
:: SimSettings =
	{ sim_spec :: !MTDeviceSpec                //* The Device Spec
	, humidities :: ![(UInt8, UInt16)]         //* Environment humidity
	, temps :: ![(UInt8, UInt16)]              //* Environment humidity
	, d_vals :: ![(UInt8, DigitalPeripheral)]  //* List of Digital pins, with their values
	, a_vals :: ![(UInt8, AnaloguePeripheral)] //* List of Analoge pins, with their values
	, timeStep :: !Int                         //* Amount of time that elapses every loop
	}

instance zero SimSettings

derive class iTask SimSettings

/**
 * The main loop of the simulator as in client.c
 */
loop :: !SimSettings !(SimChannels sds) !(Shared sds` BCSimState) -> Task BCSimState | RWShared sds & RWShared sds`
