#ifndef INTERRUPTS_H_
#define INTERRUPTS_H_

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
#include <stdint.h>
#include "bctypes.h"

#define GET_MASK(pin, mode) ((uint64_t)1 << (pin * 5 + mode))
#define SET_BIT(mask, pin, mode)\
	if (pin < 12) {\
		mask[0] |= GET_MASK(pin, mode);\
	} else {\
		mask[1] |= GET_MASK((pin - 12), mode);\
	}
#define CLEAR_BIT(mask, pin, mode)\
	if (pin < 12) {\
		mask[0] &= ~GET_MASK(pin, mode);\
	} else {\
		mask[1] &= ~GET_MASK((pin - 12), mode);\
	}
#define GET_BIT(mask, pin, mode)\
	((pin < 12) ? mask[0] & GET_MASK(pin, mode) :\
		mask[1] & GET_MASK((pin - 12), mode))

void real_isr(uint16_t pin, enum InterruptMode mode);

void enable_interrupt(uint16_t pin, enum InterruptMode mode);
void disable_interrupt(uint16_t pin, enum InterruptMode mode);
void process_interrupts();
bool pending_interrupts();
bool active_interrupts();

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* INTERRUPTS_H_ */
